/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse.dialogs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.continuousassurance.swamp.cli.SwampApiWrapper;
import org.continuousassurance.swamp.eclipse.Activator;
import org.continuousassurance.swamp.eclipse.Utils;
import org.continuousassurance.swamp.eclipse.dialogs.DialogUtil;
import org.continuousassurance.swamp.session.util.Proxy;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.console.MessageConsoleStream;

public class AuthenticationDialog
extends TitleAreaDialog {
    private Combo hostnameCombo;
    private Text otherHostnameText;
    private Text usernameText;
    private Text passwordText;
    private static final String AUTHENTICATION_TITLE = "SWAMP Authentication";
    private static final String AUTHENTICATION_PROMPT = "Please enter your authentication information for the SWAMP.";
    private static final String INVALID_MESSAGE = "Invalid username or password.";
    private static final String HOST_COMBO_HELP = "Select the SWAMP host that you want to connect to.";
    private static final String USERNAME_HELP = "Enter your SWAMP username.";
    private static final String PASSWORD_HELP = "Enter your SWAMP password.";
    private static final String LOGIN_CAPTION = "Login";
    private static final String MIR_SWAMP_DESCRIPTION = "MIR";
    private static final String JSON_UNLISTED_HOSTS_KEY = "canSpecifyUnlistedHosts";
    private static final String JSON_HOSTS_LIST_KEY = "hosts";
    private static final String JSON_HOST_NAME_KEY = "name";
    private static final String JSON_HOST_DESCRIPTION_KEY = "description";
    private static final String OTHER_OPTION = "Other";
    private static final String NO_HOST_SPECIFIED = "Invalid hostname specified.";
    private static final String JSON_CONFIG_FILENAME = "SWAMP_hosts.json";
    private SwampApiWrapper api;
    private MessageConsoleStream out;
    private Shell shell;

    public AuthenticationDialog(Shell parentShell, MessageConsoleStream stream) {
        super(parentShell);
        this.shell = parentShell;
        this.out = stream;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        this.setTitle(AUTHENTICATION_TITLE);
        this.setMessage(AUTHENTICATION_PROMPT);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        DialogUtil.initializeLabelWidget("Hostname: ", 0, container);
        this.hostnameCombo = DialogUtil.initializeComboWidget(container, new GridData(4, 0, true, false), AuthenticationDialog.getAvailableHostnames());
        this.hostnameCombo.addHelpListener(e -> MessageDialog.openInformation((Shell)this.shell, (String)"Help", (String)HOST_COMBO_HELP));
        this.hostnameCombo.select(0);
        this.hostnameCombo.addSelectionListener((SelectionListener)new HostComboSelectionListener(this.hostnameCombo));
        DialogUtil.initializeLabelWidget("Other hostname:", 0, container);
        this.otherHostnameText = DialogUtil.initializeTextWidget(2052, container, new GridData(4, 0, true, false));
        this.otherHostnameText.setEnabled(false);
        DialogUtil.initializeLabelWidget("Username: ", 0, container);
        this.usernameText = DialogUtil.initializeTextWidget(2052, container, new GridData(4, 0, true, false));
        this.usernameText.addHelpListener(e -> MessageDialog.openInformation((Shell)this.shell, (String)"Help", (String)USERNAME_HELP));
        this.usernameText.setFocus();
        DialogUtil.initializeLabelWidget("Password: ", 0, container);
        this.passwordText = DialogUtil.initializeTextWidget(0x400800, container, new GridData(4, 0, true, false));
        this.passwordText.addHelpListener(e -> MessageDialog.openInformation((Shell)this.shell, (String)"Help", (String)PASSWORD_HELP));
        return area;
    }

    private static String[] getAvailableHostnames() {
        Location configLoc = Platform.getInstallLocation();
        String filePath = String.valueOf(configLoc.getURL().getPath()) + JSON_CONFIG_FILENAME;
        File f = new File(filePath);
        ArrayList<String> hosts = new ArrayList<String>();
        if (f.exists()) {
            FileInputStream is = null;
            JsonReader reader = null;
            try {
                is = new FileInputStream(f);
                reader = Json.createReader((InputStream)is);
                JsonObject info = reader.readObject();
                JsonArray hostArray = info.getJsonArray(JSON_HOSTS_LIST_KEY);
                int i = 0;
                while (i < hostArray.size()) {
                    JsonObject o = hostArray.getJsonObject(i);
                    String host = o.getString(JSON_HOST_NAME_KEY);
                    String description = o.getString(JSON_HOST_DESCRIPTION_KEY);
                    hosts.add(String.valueOf(host) + " (" + description + ")");
                    ++i;
                }
                if (info.getBoolean(JSON_UNLISTED_HOSTS_KEY)) {
                    hosts.add(OTHER_OPTION);
                }
                String[] stringArray = hosts.toArray(new String[0]);
                return stringArray;
            }
            catch (Exception e) {
                e.printStackTrace();
                String[] stringArray = AuthenticationDialog.getDefaultHostnames();
                return stringArray;
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (reader != null) {
                    reader.close();
                }
            }
        }
        return AuthenticationDialog.getDefaultHostnames();
    }

    private static String[] getDefaultHostnames() {
        String[] array = new String[]{"https://www.mir-swamp.org (MIR)"};
        return array;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, LOGIN_CAPTION, true);
        this.createButton(parent, 1, "Cancel", false);
    }

    private void setInvalidMsgAndClearPrompts() {
        this.out.println(String.valueOf(Utils.getBracketedTimestamp()) + "Error: Invalid username and/or password entered.");
        this.setMessage("Invalid username or password.\nPlease enter your authentication information for the SWAMP.");
        this.usernameText.setText("");
        this.usernameText.setFocus();
        this.passwordText.setText("");
    }

    public SwampApiWrapper getSwampApiWrapper() {
        return this.api;
    }

    protected Proxy getProxy(String swamp_host) {
        Proxy proxy = new Proxy();
        IProxyService service = Activator.getDefault().getProxyService();
        if (service != null && service.isProxiesEnabled()) {
            String[] stringArray = service.getNonProxiedHosts();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String host = stringArray[n2];
                if (host.equalsIgnoreCase(swamp_host)) {
                    return proxy;
                }
                ++n2;
            }
            IProxyData iproxy_data = null;
            if (service.getProxyData("HTTPS").getHost() != null && service.getProxyData("HTTPS").getPort() != -1) {
                iproxy_data = service.getProxyData("HTTPS");
            } else if (service.getProxyData("HTTP").getHost() != null && service.getProxyData("HTTP").getPort() != -1) {
                iproxy_data = service.getProxyData("HTTP");
            }
            if (iproxy_data != null) {
                proxy.setHost(iproxy_data.getHost());
                proxy.setPort(iproxy_data.getPort());
                if (iproxy_data.getUserId() != null && iproxy_data.getPassword() != null) {
                    proxy.setUsername(iproxy_data.getUserId());
                    proxy.setPassword(iproxy_data.getPassword());
                }
                proxy.setScheme(iproxy_data.getType().toLowerCase());
                proxy.setConfigured(true);
            }
        }
        return proxy;
    }

    protected void okPressed() {
        String id;
        String username = this.usernameText.getText();
        String password = this.passwordText.getText();
        int index = this.hostnameCombo.getSelectionIndex();
        if (index < 0) {
            this.out.println(String.valueOf(Utils.getBracketedTimestamp()) + "Error: Invalid hostname specified.");
            this.setMessage(NO_HOST_SPECIFIED);
            this.usernameText.setText("");
            this.usernameText.setFocus();
            this.passwordText.setText("");
            return;
        }
        String hostname = this.hostnameCombo.getItem(index);
        hostname = hostname.equals(OTHER_OPTION) ? this.otherHostnameText.getText() : hostname.split(" ")[0];
        System.out.println("Hostname: " + hostname);
        if (hostname.length() == 0) {
            this.out.println(String.valueOf(Utils.getBracketedTimestamp()) + "Error: No host specified.");
            return;
        }
        if (username.length() == 0 || password.length() == 0) {
            this.setInvalidMsgAndClearPrompts();
            return;
        }
        try {
            this.api = new SwampApiWrapper();
            System.out.println("Hostname: " + hostname);
            id = this.api.login(username, password, hostname, this.getProxy(new URL(hostname).getHost()), null);
            this.api.saveSession();
        }
        catch (Exception exception) {
            this.setInvalidMsgAndClearPrompts();
            return;
        }
        if (id == null) {
            this.setInvalidMsgAndClearPrompts();
            return;
        }
        Activator.setLoggedIn(true);
        Activator.setHostname(hostname);
        super.okPressed();
    }

    private class HostComboSelectionListener
    implements SelectionListener {
        private Combo combo;

        public HostComboSelectionListener(Combo c) {
            this.combo = c;
        }

        public void widgetSelected(SelectionEvent e) {
            int selection = this.combo.getSelectionIndex();
            if (this.combo.getItem(selection).equals(AuthenticationDialog.OTHER_OPTION)) {
                AuthenticationDialog.this.otherHostnameText.setEnabled(true);
            } else {
                AuthenticationDialog.this.otherHostnameText.setEnabled(false);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

