/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse.ui;

import java.util.Comparator;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SortListener
implements Listener {
    String[] keys;

    public SortListener(String[] dataKeys) {
        this.keys = dataKeys;
    }

    public void handleEvent(Event e) {
        TableColumn selectedCol = (TableColumn)e.widget;
        Table table = selectedCol.getParent();
        int dir = table.getSortDirection();
        if (table.getSortColumn() == selectedCol) {
            dir = dir == 128 ? 1024 : 128;
        } else {
            dir = 128;
            table.setSortColumn(selectedCol);
        }
        table.setSortDirection(dir);
        Comparator comparator = (Comparator)selectedCol.getData();
        this.sortRows(table, comparator);
    }

    private void sortRows(Table table, Comparator<TableItem> comparator) {
        if (comparator == null || table == null) {
            return;
        }
        TableItem[] items = table.getItems();
        int dir = table.getSortDirection();
        int i = 1;
        while (i < items.length) {
            int j = 0;
            while (j < i) {
                if (comparator.compare(items[i], items[j]) < 0 && dir == 128 || comparator.compare(items[i], items[j]) > 0 && dir == 1024) {
                    Object obj;
                    int numCols = table.getColumnCount();
                    String[] values = new String[numCols];
                    int k = 0;
                    while (k < numCols) {
                        values[k] = items[i].getText(k);
                        ++k;
                    }
                    TableItem item = new TableItem(table, 0, j);
                    item.setText(values);
                    if (this.keys != null && this.keys.length > 0) {
                        String[] stringArray = this.keys;
                        int n = this.keys.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String key = stringArray[n2];
                            Object obj2 = items[i].getData(key);
                            if (obj2 != null) {
                                item.setData(key, obj2);
                            }
                            ++n2;
                        }
                    }
                    if ((obj = items[i].getData()) != null) {
                        item.setData(obj);
                    }
                    items[i].dispose();
                    items = table.getItems();
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void sortByCol(TableColumn col) {
        Listener[] listeners = col.getListeners(13);
        if (listeners.length > 0) {
            SortListener sl = (SortListener)listeners[0];
            Comparator comparator = (Comparator)col.getData();
            sl.sortRows(col.getParent(), comparator);
        }
    }
}

