#!/s/std/bin/perl


use strict;

my $threads = 10;
my $iterations = 4000; # 10000
my $i;

my $numKeys = 400;
my @keyArray;
my @servers; 
my @ports;
my $numServers; 
my $clientName = "./client";


sub do_one
{
    my $server = $_[0];
    my $port = $_[1];
    my $key = $_[2];
    my $value = $_[3];

    my $cmd = $clientName . " -h ".$server.":".$port." -k ".$key." -v ".$value;
#    print "Executing command $cmd\n";
    my $result = qx($cmd);
    return $result;

}

sub do_one_read
{
    my $server = $_[0];
    my $port = $_[1];
    my $key = $_[2];

    my $cmd = $clientName . " -h ".$server.":".$port." -k ".$key;
#    print "Executing command $cmd\n";
    my $result = qx($cmd);
    return $result;

}

sub run_stress_test_read
{
    my $index = $_[0];
    my $numServers = $_[1];
    my $i = 0;
    my $value;
    my $FILE;
    my $fileName = ">logs/result-".$index.".log";

#    print "Filename = $fileName\n";

    open FILE, $fileName || die "Cannot open file: $!\n";

    
    print "running test $index\n";
    for ($i = 0 ; $i < $iterations; $i++) {
	$value = $index * $iterations + $i;
	my $iServer = int(rand($numServers));
	my $key = $keyArray[$i % $numKeys];
	my $result = do_one_read($servers[$iServer],$ports[$iServer],$key,$value);
	print FILE "### value=[$value] for $key:$servers[$iServer]\n";
	print FILE $result;
#	print "Comamnd result $value =  $result\n";
#	print "$index:$i\n";
    }

    close FILE;
}

sub run_stress_test
{
    my $index = $_[0];
    my $numServers = $_[1];
    my $i = 0;
    my $value;
    my $FILE;
    my $fileName = ">logs/result-".$index.".log";
#    print "Filename = $fileName\n";
    open FILE, $fileName || die "Cannot open file: $!\n";

    
    print "running test $index\n";
    for ($i = 0 ; $i < $iterations; $i++) {
	$value = $index * $iterations + $i;
	my $iServer = int(rand($numServers));
	my $key = $keyArray[int(rand($numKeys))];
	my $result = do_one($servers[$iServer],$ports[$iServer],$key,$value);
	print FILE "### value=[$value] for $key:$servers[$iServer]\n";
	print FILE $result;
#	print "Comamnd result $value =  $result\n";
#	print "$index:$i\n";
    }

    close FILE;
}

my @results; # sized by values

sub read_results
{
    my $index = $_[0];
    my $i = 0;
    my $FILE;
    my $fileName = "<logs/result-".$index.".log";
    my $newValue;

    open FILE, $fileName || die "Cannot open file: $!\n";
    while (<FILE>) {
	my $key = -1;
	my $oldValue;

	if (/\#\#\#\ value=\[(\d+)\]/) {
#	    print "Found new value $1\n";
	    $newValue = $1;
	}
	if ((/\[key\-name(\d+)\]=nil/) || 
	    (/\[key\-name(\d+)\]=NIL/) ||
	    (/\[key\-name(\d+)\]=\[NIL\]/)) {
	    $key = $1;
	    $oldValue = 'nil';
#	    print "Found key $1 = nil\n";
	}
	elsif (/\[key\-name(\d+)\]=\[(\d+)\]/) {
	    $key = $1;
	    $oldValue = $2;
#	    print "Found key $1 = $2\n";
	} 
	if ($key != -1) {
	    my $chain = {};
	    if (exists $results[$key]) {
		$chain = $results[$key];
	    } else {
		$results[$key] = $chain;
	    }
#	    print "Inserting $key: $oldValue -> $newValue\n";
	    $chain->{$oldValue} = $newValue;
	    $newValue = 0;
	}
	    
	
    }
    close FILE;
}


# initialize servers

my $doTest = 1;
my $doResults = 1;

if ($#ARGV >= 0) {
    foreach $i (0 .. $#ARGV) {
	if ($ARGV[$1] eq "-nt") {
	    $doTest = 0;
	} elsif  ($ARGV[$1] eq "-nr") {
	    $doResults = 0;
	}
    }
}

if ($doTest) {

    open FILE, "servers.txt";
    my $numServers = 0;
    while (<FILE>) {
#    print $_;
	if (/(.+):(.+)/) {
	    @servers[$numServers] = $1;
	    @ports[$numServers] = $2;
	    $numServers++;
	}
    }
    close FILE;

$numServers = 1;
    
# initialize keys
    
    for (my $i = 0; $i < $numKeys; $i++) {
	$keyArray[$i] = "key-name".$i;
	do_one($servers[0],$ports[0],$keyArray[$i],"99999");
    }
    
# main loop
    
    
    for ($i = 0; $i < $threads; $i++) {
	
	my $pid = fork();
	if ($pid == 0) {	    
	    # in child
	    # call routine to run tests
	    run_stress_test_read($i,$numServers);
	    exit();
	}
    }
    
    
    for ($i = 0; $i < $iterations; $i++) {
	wait();
    }
}

if ($doResults) {
# Read in results
    
    
    for ($i = 0; $i < $threads; $i++) {
	read_results($i);
    }
    
    
# Check results
    
    my $mistakes = 0;
    for ($i = 0; $i < $numKeys; $i++) {
	my $key = "$i";
	if (exists $results[$key]) {
	    my $chain = $results[$key];
	    my $chainSize = scalar keys %$chain;
	    my $elems = 0;
# Dump results
	    
#	while( my ($k, $v) = each %$chain ) {
#	    print "key: $k, value: $v.\n";
#	}
	    
	    
#	print "$key: ";
	    my $value = "99999";
	    while (exists $chain->{$value}) {
		
#	    print "-> $value ";
		$value = $chain->{$value};
		$elems++;
		if ($elems > 2 * $chainSize) {
		    print "$key: chain too big\n";
		    last;
		}
	    }
	    if ($chainSize != $elems) {
		print "$key: chain is $chainSize, elems is $elems\n";
		$mistakes++;
	    }
	}
    }
    print "Mistakes: $mistakes\n";
}
