/*
 * client.c: A very, very primitive HTTP client.
 * 
 * To run, try: 
 *      client www.cs.wisc.edu 80 /
 *
 * Sends one HTTP request to the specified HTTP server.
 * Prints out the HTTP response.
 *
 */

#include "rio.h"

typedef struct Host host;
struct Host  
{
	char* hostname;
	int portno;
	host *next;
};
/*
 * Send an HTTP request for the specified file 
 */
void clientSend(int fd, char *filename)
{
  char buf[MAXLINE];
  char hostname[MAXLINE];
  Gethostname(hostname, MAXLINE);

  /* Form and send the HTTP request */
  sprintf(buf, "GET %s HTTP/1.1\n", filename);
  sprintf(buf, "%shost: %s\n\r\n", buf, hostname);
  Rio_writen(fd, buf, strlen(buf));
}
  
/*
 * Read the HTTP response and print it out
 */
void clientPrint(int fd)
{
  rio_t rio;
  char buf[MAXBUF];  
  int length = 0;
  int n;
  
  Rio_readinitb(&rio, fd);

  /* Read and display the HTTP Header */
  n = Rio_readlineb(&rio, buf, MAXBUF);
  while (strcmp(buf, "\r\n") && (n > 0)) {
    printf("Header: %s", buf);
    n = Rio_readlineb(&rio, buf, MAXBUF);

    /* If you want to look for certain HTTP tags... */
    if (sscanf(buf, "Content-Length: %d ", &length) == 1) {
      printf("Length = %d\n", length);
    }
  }

  /* Read and display the HTTP Body */
  n = Rio_readlineb(&rio, buf, MAXBUF);
  while (n > 0) {
    printf("%s", buf);
    n = Rio_readlineb(&rio, buf, MAXBUF);
  }
}

void hostprocesser(char *line,int *hostcount,host **hostlist)
{
	char *hoststring=NULL,*portno,*hostname,*parsestring,*saveptr1,*saveptr2;
	int port,i;
	parsestring = line;
	host *h,*temp,*head=NULL;
	while((hoststring = (char *)strtok_r(line,",",&saveptr1))!=NULL)
	{
		line = NULL;
		parsestring = hoststring;
		for(i=0;i<2;i++)
		{
			if(i==0)
			{
				h = malloc(sizeof(host)*1);
				hostname = (char *)strtok_r(parsestring,":",&saveptr2);
				h->hostname = hostname;
			}
			if(i==1)
			{
				portno = (char *)strtok_r(NULL,":",&saveptr2);
				port = atoi(portno);
				h->portno = port;
				h->next = NULL;
			}		
		}
		
		if(head!=NULL)
		{
			temp = head;
			h->next=temp;
			head = h;
			*hostcount= *hostcount +1;	
		}
		else
		{
			head = h;
			head->next = NULL;
			*hostcount=*hostcount + 1;
		}
	   }
	   *hostlist = head;
}

host* getElement(host **hostlist,int index)
{
	host* head;
	int i;
	if(hostlist!=NULL)
	{
		head = *hostlist;
		for(i=0;i<(index-1);i++)
		{
			if(head!=NULL)
			{
				head = head->next;
			}
			else
			{
				break;
			}
		}
	}
	return head;
}

void readServerFile(char *filename,int *hostcount,host** hostlist)
{
	FILE* fp;
	fp = fopen(filename,"r");
	char* hostname;
	int portno;
	host *head=NULL,*temp,*h;
	hostname = malloc(100);
	while(fscanf(fp,"%s %d\n",hostname,&portno)!=EOF)
	{
	     h = malloc(sizeof(host));
	     h->hostname = hostname;
	     h->portno = portno;
	     if(head!=NULL)
	     {
		temp = head;
		h->next=temp;
		head = h;
		*hostcount++;	
	     }
	     else
	     {
		head = h;
		head->next = NULL;
		*hostcount++;
	     }
	}
	*hostlist = head;
}

int main(int argc, char *argv[])
{
  char *hostname, *filename,*key,*value,*query;
  int port;
  int clientfd;
  int hostcount=0;
  int readreq=0;
  int index=10;
  host *HostList;
  host *ServerDetails;

  if (argc < 3||argc==4||argc==6||argc>7) 
  {
    fprintf(stderr, "Usage: %s -k key\n", argv[0]);
    fprintf(stderr,"OR\n");
    fprintf(stderr, "Usage: %s -k key -v value\n", argv[0]);
    fprintf(stderr,"OR\n");
    fprintf(stderr, "Usage: %s -h host:port[,host2:port2[,host3:port3]] -k key\n", argv[0]);
    fprintf(stderr,"OR\n");
    fprintf(stderr, "Usage: %s -h host:port[,host2:port2[,host3:port3]] -k key -v value\n", argv[0]);
    exit(1);
  }

  if(argc==3)
  {
	readServerFile("server.txt",&hostcount,&HostList); 
	key = argv[2];
  	readreq=1;
	value = "NIL";
  }

  if(argc==5)
  {
	if(!strncmp(argv[1],"-h",2))
	{
  		hostprocesser(argv[2],&hostcount,&HostList);
		key = argv[4];	
		readreq = 1;
		value = "NIL";
	}
	else
	{  
	 	readServerFile("server.txt",&hostcount,&HostList); 
		key = argv[2];
		value = argv[4];
  	}
  }

  if(argc==7)
  {
  	hostprocesser(argv[2],&hostcount,&HostList);
	key = argv[4];
	value = argv[6];
  }


  if(strchr(key,(int)'[')!=NULL||strchr(key,(int)']')!=NULL)
  {
    fprintf(stderr, "key cannot contain '[' or ']' \n");
    exit(1);
  }

  if(strchr(value,(int)'[')!=NULL||strchr(value,(int)']')!=NULL)
  {
    fprintf(stderr, "Value cannot contain '[' or ']' \n");
    exit(1);
  }

  if(index>hostcount)
	index = 1;
  ServerDetails = getElement(&HostList,index);
  hostname = ServerDetails->hostname;
  port = ServerDetails->portno;

  //printf("%s\n",hostname);
  //printf("%d\n",port);

  /* Open a single connection to the specified host and port */
  query = malloc(sizeof(key)+sizeof(value)+6);
  if(readreq==0)
  {
	  sprintf(query,"[%s]=[%s]",key,value);
  }
  else
  {
	  sprintf(query,"[%s]",key);
  }
  clientfd = Open_clientfd(hostname, port);
  clientSend(clientfd, query);
  clientPrint(clientfd);
  Close(clientfd);
  exit(0);
}
