#include "rio.h"
#include "request.h"

/* 
 * server.c: A very, very simple web server
 *
 * To run:
 *  server <portnum (above 2000)>
 *
 * Repeatedly handles HTTP requests sent to this port number.
 * Most of the work is done within routines written in request.c
 *
 */

void getargs(int *port, int argc, char *argv[])
{
  if (argc != 2) {
    fprintf(stderr, "Usage: %s <port>\n", argv[0]);
    exit(1);
  }
  *port = atoi(argv[1]);
}


void pipe_handler(int n)
{
  return;
}

int main(int argc, char *argv[])
{

  int listenfd, connfd, port, clientlen;
  struct sockaddr_in clientaddr;

  getargs(&port, argc, argv);


  signal(SIGPIPE,&pipe_handler);

  /* 
   * CS537: Create some threads...
   */

  listenfd = Open_listenfd(port);
  while (1) {
    clientlen = sizeof(clientaddr);
    connfd = Accept(listenfd, (SA *)&clientaddr, &clientlen);

    /* 
     * CS537: Don't handle the request in the main thread.
     * Save the relevant info in a buffer and have one of the worker threads 
     * do the work.
     */ 
    requestHandle(connfd);

    Close(connfd);
  }

}


    


 
