/*
 * client.c: A very, very primitive HTTP client.
 * 
 * To run, try: 
 *      client www.cs.wisc.edu 80 /
 *
 * Sends one HTTP request to the specified HTTP server.
 * Prints out the HTTP response.
 *
*/

#include "rio.h"
#include <pthread.h>
#include <sys/time.h>
typedef struct Host host;
struct Host  
{
	char* hostname;
	int portno;
	host *next;
};

typedef struct Threaddata threaddata;

struct Threaddata
{
	int fd;
	char *query; 
	char *hostname;
};


long long timeval_diff(struct timeval *difference,
             struct timeval *end_time,
             struct timeval *start_time
            )
{
  struct timeval temp_diff;

  if(difference==NULL)
  {
    difference=&temp_diff;
  }

  difference->tv_sec =end_time->tv_sec -start_time->tv_sec ;
  difference->tv_usec=end_time->tv_usec-start_time->tv_usec;

  /* Using while instead of if below makes the code slightly more robust. */

  while(difference->tv_usec<0)
  {
    difference->tv_usec+=1000000;
    difference->tv_sec -=1;
  }

  return 1000000LL*difference->tv_sec+
                   difference->tv_usec;

}

/*
 * Send an HTTP request for the specified file 
*/

void clientSend(void *threadargs)
{
  int fd;
  char *query;
  threaddata* data;
  data = (threaddata *) threadargs;

  //fd = Open_clientfd(hostname, port);
  fd = data->fd;
  query = data->query;   

  char buf[MAXLINE];
  char hostname[MAXLINE];
  Gethostname(hostname, MAXLINE);
  /* Form and send the HTTP request */

  //fd = Open_clientfd(hostname, port);
  //printf("Query: %s\n",query);

  sprintf(buf, "GET %s HTTP/1.1\n", query);
  sprintf(buf, "%shost: %s\n\r\n", buf, hostname);

  //printf("DEBUG 2\n");

  Rio_writen(fd, buf, strlen(buf));

}
  
/*
 * Read the HTTP response and print it out
*/
void clientPrint(void *threadargs)
{
  int fd;
  threaddata* data;
  data = (threaddata *) threadargs;
  fd = data->fd;
  rio_t rio;
  char buf[MAXBUF]="";  
  int n;
  
  /* Read and display the HTTP Header */
  Rio_readinitb(&rio, fd);
  n = Rio_readlineb(&rio, buf, MAXBUF);
 
  while (strcmp(buf, "\r\n") && (n > 0)) 
  {
    n = Rio_readlineb(&rio, buf, MAXBUF);
  }
 
   //printf("%s",buf);
}

void sender(void *threadargs)
{

  clientSend(threadargs);

}

void receiver(void *threadargs)
{

  clientPrint(threadargs);

}

void hostprocesser(char *line,int *hostcount,host **hostlist)
{

	char *hoststring=NULL,*portno,*hostname,*parsestring,*saveptr1,*saveptr2;
	int port,i;
	parsestring = line;
	host *h,*temp,*head=NULL;

	while((hoststring = (char *)strtok_r(line,",",&saveptr1))!=NULL)
	{
		line = NULL;
		parsestring = hoststring;
		for(i=0;i<2;i++)
		{
			if(i==0)
			{
				h = malloc(sizeof(host)*1);
				hostname = (char *)strtok_r(parsestring,":",&saveptr2);
				h->hostname = hostname;
			}
			if(i==1)
			{
				portno = (char *)strtok_r(NULL,":",&saveptr2);
				port = atoi(portno);
				h->portno = port;
				h->next = NULL;
			}		
		}
		
		if(head!=NULL)
		{
			temp = head;
			h->next=temp;
			head = h;
		//	*hostcount= *hostcount +1;	
		}
		else
		{
			head = h;
			head->next = NULL;
		//	*hostcount=*hostcount + 1;
		}
	   }
	   *hostlist = head;
}

host* getElement(host **hostlist,int index)
{
	host* node;
	int i;
	if(hostlist!=NULL)
	{
		node = *hostlist;
		for(i=0;i<(index-1);i++)
		{
			if(node!=NULL)
			{
				node = node->next;
				//printf("Node: %s\n",node->hostname);
			}
			else
			{
				break;
			}
		}
		return node;
	}
	//printf("Get Element: %s\n",head->hostname);
	//return head;
}

void readServerFile(char *filename,int *hostcount,host** hostlist)
{
	FILE* fp;
	fp = fopen(filename,"r");
	char* hostname;
	int portno;
	host *head=NULL,*temp=NULL;
	hostname = malloc(100);
	while(fscanf(fp,"%[^:]:%d\n",hostname,&portno)!=EOF)
	{
	     if(head==NULL)
	     {
	     	head = malloc(sizeof(host));
		head->hostname = malloc(100);
	     	strcpy(head->hostname,hostname);
	     	head->portno = portno;
	     	head->next = NULL;
	//	printf("HOST:%s\n",hostname);	
	     }
	     else
	     {
	     	temp = head;
	
		while(temp->next!=NULL)
			temp = temp->next;

		temp->next = malloc(sizeof(host));
		temp = temp->next;
		temp->hostname = malloc(100);
		strcpy(temp->hostname,hostname);
		temp->portno = portno;
		temp->next = NULL;
	//	printf("HOST:%s\n",hostname);
	//	printf("READ: %s\n",head->hostname);
	     }
	}

	hostname = malloc(100);
	*hostlist = head;
//	printf("READ: %s\n",head->next->hostname);
	fclose(fp);
}

int main(int argc, char *argv[])
{
  char *hostname="",*key="",*value="",*query="";
  int port;
  int clientfd;
  int hostcount=0;
  int readreq=0;
  int index=1;
  int stdio =0;
  int nostdio =1;
  int count=0;
  //pthread_t sendthread,recvthread;
  struct timeval starttime,endtime;


  host *HostList;
  host *ServerDetails;

  gettimeofday(&starttime,NULL);
  FILE* fp = fopen("timer","a");
  fprintf(fp,"%lf\n" , (double)(starttime.tv_sec*1000000LL+starttime.tv_usec)/1000000.0);
  
  if (argc < 2||argc==6||argc>7) 
  {
    
    fprintf(stderr, "Usage: %s -i\n", argv[0]);
    fprintf(stderr,"OR\n");
    fprintf(stderr, "Usage: %s -h host:port[,host2:port2[,host3:port3]] -i\n", argv[0]);
    fprintf(stderr,"OR\n");
    fprintf(stderr, "Usage: %s -k key\n", argv[0]);
    fprintf(stderr,"OR\n");
    fprintf(stderr, "Usage: %s -k key -v value\n", argv[0]);
    fprintf(stderr,"OR\n");
    fprintf(stderr, "Usage: %s -h host:port[,host2:port2[,host3:port3]] -k key\n", argv[0]);
    fprintf(stderr,"OR\n");
    fprintf(stderr, "Usage: %s -h host:port[,host2:port2[,host3:port3]] -k key -v value\n", argv[0]);
    exit(1);
  }

  if(argc==2)
  {
        readServerFile("server.txt",&hostcount,&HostList); 
	stdio = 1;
 	//printf("DEBUG ");
  }
  
  if(argc==3)
  {
	readServerFile("server.txt",&hostcount,&HostList); 
	key = argv[2];
  	readreq=1;
	value = "NIL";
  }

  if(argc==4)
  {
	if(!strncmp(argv[1],"-h",2) && !strncmp(argv[3],"-i",2))
	{
		
  		hostprocesser(argv[2],&hostcount,&HostList);
		stdio=1;
		nostdio=0;
	}
  }

  if(argc==5)
  {
	if(!strncmp(argv[1],"-h",2))
	{
  		hostprocesser(argv[2],&hostcount,&HostList);
		key = argv[4];	
		readreq = 1;
		value = "NIL";
	}
	else
	{  
	 	readServerFile("server.txt",&hostcount,&HostList); 
		key = argv[2];
		value = argv[4];
  	}
  }

  if(argc==7)
  {
  	hostprocesser(argv[2],&hostcount,&HostList);
	key = argv[4];
	value = argv[6];
  }


  if(strchr(key,(int)'[')!=NULL||strchr(key,(int)']')!=NULL)
  {
    fprintf(stderr, "key cannot contain '[' or ']' \n");
    exit(1);
  }

  if(strchr(value,(int)'[')!=NULL||strchr(value,(int)']')!=NULL)
  {
    fprintf(stderr, "Value cannot contain '[' or ']' \n");
    exit(1);
  }

  //gettimeofday(&starttime,NULL);
  //printf("Start Time : %ld sec %ld microsec" , starttime.tv_sec,starttime.tv_usec);
 
  count = 0; 
  do
  {
  //if(index>hostcount)
  index = (count%4)+1;
  //index=1;
  //printf("Index: %d\n",index);
  ServerDetails = getElement(&HostList,index);
  hostname = ServerDetails->hostname;
  port = ServerDetails->portno;
  //printf("Host:%s\n",hostname);
  //printf("Port:%d\n",port);

  /* Open a single connection to the specified host and port */
  //query = malloc(sizeof(key)+sizeof(value)+6);
  query = malloc(1040);
  //strcmp(query,"");
  if(stdio==1)
  {
        //printf("Now Scanning....\n");
 	//fflush(stdout);
	//if(fscanf(stdin,"%s",query)==EOF)
	if(scanf("%s",query)==EOF)
	{
		break;
	}	
        //if(feof(stdin))
        //break; 	
        if(!strcmp(query,""))
	{
		break;
	}
  	
  }
  else
  {
  	query = malloc(sizeof(key)+sizeof(value)+6);
  	if(readreq==0)
  	{
		 sprintf(query,"[%s]=[%s]",key,value);
  	}
  	else
  	{
	 	 sprintf(query,"[%s]",key);
  	}
  }

  //if(count == 0)
  clientfd = Open_clientfd(hostname, port);
  int ret,flag;
  ret = setsockopt( clientfd, IPPROTO_TCP, TCP_NODELAY, (char *)&flag, sizeof(flag) );
  if(ret==-1)
	printf("Set Socket Option failed\n");
  threaddata *data = malloc(sizeof(threaddata));
  data->fd = clientfd;
  data->query = query;
  data->hostname = hostname; 
  clientSend((void*)data);
  clientPrint((void*)data);
  //pthread_create (&sendthread, NULL, (void *) &sender, (void *)data);
  //pthread_create (&recvthread, NULL, (void *) &receiver, (void *)data);
  //pthread_join(sendthread,NULL);
  //pthread_join(recvthread,NULL);
  Close(clientfd);
  //strcmp(query,"");
  count++;
  free(data);
  free(query);
  }
  while(stdio==1);
  
  //Close(clientfd);
  gettimeofday(&endtime,NULL);
  //printf("End Time : %ld sec %ld microsec" , endtime.tv_sec,endtime.tv_usec);
  //double diff = (double)(timeval_diff(NULL,&endtime,&starttime)/1000000);
 
   //FILE* fp = fopen("timer","a");
   //fprintf(fp,"%lf\n",(double)(timeval_diff(NULL,&endtime,&starttime)/1000000.0));
   
   fprintf(fp,"%lf\n",(double)(endtime.tv_sec*1000000LL+endtime.tv_usec)/1000000.0);
   fclose(fp);
  //printf("Difference: %lf seconds\n",(double)(timeval_diff(NULL,&endtime,&starttime)/1000000));
  exit(0);
}
