import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;

public class BackchannelListener implements Runnable {

	byte[] messageBuf;
	
 BackchannelListener(byte[] inBuf) 
 {
	 		messageBuf = inBuf;
 }
	 
	@Override
	public void run() {
		ByteArrayInputStream b_in = new ByteArrayInputStream(messageBuf);
		
		ArrayList<Record> arr;
		int row = 0, table = 0;

		try {
			
			//TODO Do a check if sender==receiver, then return
			   
			  /* if(_servers[0].getIaddr() ==  dgram.getAddress() &&
				  _servers[0].getPort() == dgram.getPort()) */
			   
			ObjectInputStream o_in = new ObjectInputStream(b_in);
			Object o = o_in.readObject();
			Message recvMsg = (Message)o;
			
			if(recvMsg.getSenderIndex() == Server.myServerIndex) {
				return;
			}
			
			Server.serverConf[recvMsg.getSenderIndex()].setTstamp(System.currentTimeMillis());
			
			if(Constants.IS_DEBUG_MODE)
			{
				if(recvMsg.getType() == Message.Type.KEEPALIVE)
					System.out.println("---------Got KEEPALIVE FROM "+ recvMsg.getSenderIndex() +"-------------\n");
			}
			
			if(recvMsg.getType() == Message.Type.GCREQUEST)
			{
				if(Constants.IS_DEBUG_MODE) {
					System.out.println("Received GCREQUEST message");
				}
				
				HashMap<Integer, Integer> myVectorClock = Server.getVectorClockMap();
				
				int gcNum = recvMsg.getGCUpdateNumber();
				int senderIndex = recvMsg.getSenderIndex();
				
				if(myVectorClock.get(senderIndex) > gcNum)
				{
					Message sendMsg = new Message();
					sendMsg.setType(Message.Type.GCRESPONSE);
					sendMsg.setSenderIndex(Server.myServerIndex);
					sendMsg.setGCUpdateNumber(gcNum);
					sendDatagramMessage(sendMsg, senderIndex);
				}
			}
			else if(recvMsg.getType() == Message.Type.GCRESPONSE)
			{
				if(recvMsg.getGCUpdateNumber() == Server.gcUpdateNumber)
					Server.gcResponseCount++;
				
				if(Server.gcResponseCount == (Constants.NUM_NODES -1))
				{
					if(Constants.IS_DEBUG_MODE) {
						System.out.println("Received all GCRESPONSE message");
					}
					
					Server.gcResponseCount = 0;
					Server.gcUpdateNumber = -1;
					
					Message sendMsg = new Message();
					sendMsg.setType(Message.Type.GCCOMMIT);
					sendMsg.setSenderIndex(Server.myServerIndex);
					int gcNum = recvMsg.getGCUpdateNumber();
					sendMsg.setGCUpdateNumber(gcNum);
					
					HeartBeat.SendMulticastMessage(sendMsg);
					
					CommitGarbageCollection(Server.myServerIndex, gcNum);
					
					if(Constants.IS_DEBUG_MODE) {
					System.out.println("After committing GC");
	        		Server.printVectorClockMaps();
					}
				}
			}
			else if(recvMsg.getType() == Message.Type.GCCOMMIT)
			{
				int gcNum = recvMsg.getGCUpdateNumber();
				int senderIndex = recvMsg.getSenderIndex();
				
				CommitGarbageCollection(senderIndex, gcNum);
			}
			else if(recvMsg.getType() == Message.Type.UPDATE || recvMsg.getType() == Message.Type.SYNC || 
					recvMsg.getType() == Message.Type.HYBRID)
			{

				if(Constants.IS_DEBUG_MODE) {
					ArrayList<Record> updts = recvMsg.getUpdateList();
					System.out.println("---------"+recvMsg.getType().toString()+" Message from Sender("+updts.size()+" records)-------------\n");
					if(! updts.isEmpty())
					  for(Record uo : updts) {
						MapValueEntry mvE = uo.getMapValueEntry();
						System.out.println("Key=["+uo.getKey()+"],Value=["+mvE.data+"],TStamp=["+mvE.tstamp+"]");
						System.out.println("Table="+uo.getTableIndex()+"Row="+ uo.getRowIndex());
					  }
					
					HashMap<Integer,Integer> clocks = recvMsg.getVectorClock();
					if(clocks != null)
					{
						for (Object key: clocks.keySet()) {
						      System.out.println("IP="+key.toString()+" Value="+clocks.get(key));
						 }
					}
					System.out.println("---------Message End-------------\n");
				}
				
				arr = recvMsg.getUpdateList();
				//writing update table
				if(! arr.isEmpty()) 
				{
					for(Record r : arr)
					{
					String key = r.getKey();
					MapValueEntry mvEntry = r.getMapValueEntry();
					Server.kvmap.putValue(key, mvEntry);		//checks timestamp
					
					row = r.getRowIndex();
					table = r.getTableIndex();
					Server.updtTracker.insertUpdate(table, row, key);
					Server.updateClock(table, row);
				  }
				   if(Constants.IS_DEBUG_MODE) {
					  System.out.println("After receiving updates");
	        		  Server.printVectorClockMaps();
					}
				}
				
				if(recvMsg.getType() == Message.Type.HYBRID)
				{
					if(Constants.IS_DEBUG_MODE) {
						System.out.println("---------Hybrid Message from Sender-------------\n");
						System.out.println("Type = "+recvMsg.getType().toString());
						ArrayList<Record> updts = recvMsg.getUpdateList();
						if(! updts.isEmpty())
						  for(Record uo : updts) {
							MapValueEntry mvE = uo.getMapValueEntry();
							System.out.println("Key=["+uo.getKey()+"],Value=["+mvE.data+"],TStamp=["+mvE.tstamp+"]");
							System.out.println("Table="+uo.getTableIndex()+"Row="+ uo.getRowIndex());
						  }
						
						HashMap<Integer,Integer> clocks = recvMsg.getVectorClock();
						if(clocks != null)
						{
							for (Object key: clocks.keySet()) {
							      System.out.println("IP="+key.toString()+" Value="+clocks.get(key));
							 }
						}
						
						HashMap<Integer,Integer> senderVectorClock = recvMsg.getVectorClock();
						HashMap<Integer,Integer> myVectorClock = Server.getVectorClockMap();
						System.out.print("Sender Clock:");
						for(int i=0; i<Constants.NUM_NODES; i++)
						{
							System.out.print(senderVectorClock.get(i)+",");
						}
						System.out.print("My Clock:");
						for(int i=0; i<Constants.NUM_NODES; i++)
						{
							System.out.print(myVectorClock.get(i)+",");
						}
						System.out.println("---------Message End-------------\n");
						
					}

					HashMap<Integer,Integer> senderVectorClock = recvMsg.getVectorClock();
					HashMap<Integer,Integer> myStartVectorClock = Server.getStartVectorClockMap();
					
					boolean isSendChkpt = false;
					
					for(int i=0; i<Constants.NUM_NODES; i++)
					{
						if(myStartVectorClock.get(i) != -1)
						{
							if(myStartVectorClock.get(i) > senderVectorClock.get(i))
							{
								isSendChkpt = true;
								break;
							}
						}
					}
					
					if(isSendChkpt)
					{
						HashMap<Integer, Integer> sendVectorClock = new HashMap<Integer, Integer>();
						MyKVMap sendKVMap = Server.readCheckpointFromFile(sendVectorClock);
						if(sendKVMap != null)
							Server.sendCheckpoint(sendKVMap, sendVectorClock, recvMsg.getSenderIndex());
						else
						{
							isSendChkpt = false;
							
							if(Constants.IS_DEBUG_MODE) {
								for(int i=0; i<Constants.NUM_NODES; i++)
								{
									System.out.println("******ERROR::CANNOT SEND CHECKPOINT");
								}
							}
						}
					}

					if(!isSendChkpt)
						sendDifference(recvMsg, false);

				}
				
			}//Message.Type.UPDATE||SYNC
			else if(recvMsg.getType() == Message.Type.HEARTBEAT)
			{
				HashMap<Integer,Integer> senderVectorClock = recvMsg.getVectorClock();
				HashMap<Integer,Integer> myStartVectorClock = Server.getStartVectorClockMap();
				
				boolean isSendChkpt = false;
				
				for(int i=0; i<Constants.NUM_NODES; i++)
				{
					if(myStartVectorClock.get(i) != -1)
					{
						if(myStartVectorClock.get(i) > senderVectorClock.get(i))
						{
							isSendChkpt = true;
							break;
						}
					}
				}
				
				if(isSendChkpt)
				{
					HashMap<Integer, Integer> sendVectorClock = new HashMap<Integer, Integer>();
					MyKVMap sendKVMap = Server.readCheckpointFromFile(sendVectorClock);
					if(sendKVMap != null)
						Server.sendCheckpoint(sendKVMap, sendVectorClock, recvMsg.getSenderIndex());
					else
					{
						isSendChkpt = false;
						
						if(Constants.IS_DEBUG_MODE) {
							for(int i=0; i<Constants.NUM_NODES; i++)
							{
								System.out.println("******ERROR::CANNOT SEND CHECKPOINT");
							}
						}
					}
				}

				if(!isSendChkpt)
					sendDifference(recvMsg, true);
				
			}//Message.Type.HEARTBEAT
			
			
			//TODO
			// Different behavior according to different Message Types
			// update clocks etc
			//

		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} // blocks
 catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public Object toObject (byte[] bytes)
	{
	  Object obj = null;
	  try {
	    ByteArrayInputStream bis = new ByteArrayInputStream (bytes);
	    ObjectInputStream ois = new ObjectInputStream (bis);
	    obj = ois.readObject();
	  }
	  catch (IOException ex) {
	    //TODO: Handle the exception
	  }
	  catch (ClassNotFoundException ex) {
	    //TODO: Handle the exception
	  }
	  return obj;
	}
	
	public void sendDifference(Message recvMsg, boolean setHybrid)
	{
		int senderIndex = recvMsg.getSenderIndex();
		Message sendMsg = new Message();
		ArrayList<Record> recordArr = new ArrayList<Record>();
		String sendKey = null;
		boolean doSendHybrid = false;
		
		MapValueEntry rcvValEntry = null;
		
		HashMap<Integer,Integer> senderVectorClock = recvMsg.getVectorClock();
		HashMap<Integer,Integer> myVectorClock = Server.getVectorClockMap();
		HashMap<Integer,Integer> myStartVectorClock = Server.getStartVectorClockMap();
		
		for(int i=0; i<Constants.NUM_NODES; i++)
		{
			if(senderVectorClock.get(i) < myStartVectorClock.get(i))
			{	
				System.out.println("UNEXPECTED: Sender vector clock less than my start");
				System.out.println("UNEXPECTED: Sender vector clock less than my start");
				return;
			}
		}
		
		sendMsg.setType(Message.Type.SYNC);
		sendMsg.setSenderIndex(Server.myServerIndex);
		sendMsg.setVectorClock(Server.getVectorClockMap());
		
		int numObjectsAccommodated = Constants.MAX_UPDATES;
		
		for(int i=0; i<Constants.NUM_NODES; i++)
		{
			int senderHighMark = senderVectorClock.get(i);
			int myHighMark = myVectorClock.get(i);
			
			//check if senderHighMark is atleast mystartvcmap, but that will create holes in receiver update map 
			if(setHybrid && myHighMark < senderHighMark)
			{
				doSendHybrid = true;
				if(Constants.IS_DEBUG_MODE) {
					System.out.println("---------Sending Hybrid Message-------------\n");
					System.out.println("myHighMark = "+myHighMark+" senderHighMark = "+senderHighMark);
				}
			}
			
			senderHighMark++;
			while(senderHighMark <= myHighMark)
			{
				rcvValEntry = null;
				
				sendKey = Server.updtTracker.getUpdate(i, senderHighMark);
				if(sendKey != null)
				{
					rcvValEntry = Server.kvmap.getValue(sendKey);
					if(rcvValEntry != null)
					{
						recordArr.add(new Record(sendKey,rcvValEntry, i, senderHighMark));
						numObjectsAccommodated--;
						
						//check how many more items can be accommodated
						if(numObjectsAccommodated == 0)
						{
							sendMsg.setUpdateList(recordArr);
							numObjectsAccommodated = allowedNumberOfObjects(sendMsg);
							if(numObjectsAccommodated == 0)	//send message
							{
								sendDatagramMessage(sendMsg, senderIndex);
								recordArr.clear();
								numObjectsAccommodated = Constants.MAX_UPDATES;
							}
						}
					}
				}
				senderHighMark++;
			}
		}//for
			
			//set last message as hybrid if needed
			if(doSendHybrid)
				sendMsg.setType(Message.Type.HYBRID);
			
			sendMsg.setUpdateList(recordArr);
			
			sendDatagramMessage(sendMsg, senderIndex);
		}
		

	private void sendDatagramMessage(Message sendMsg, int destIndex)
	{
		DatagramPacket sendPacket = null;
		ByteArrayOutputStream b_out = new ByteArrayOutputStream();

		try {
			ObjectOutputStream o_out = new ObjectOutputStream(b_out);
			o_out.writeObject(sendMsg);
			byte[] sendBuf = b_out.toByteArray();
			sendPacket = new DatagramPacket(sendBuf, sendBuf.length, Server.serverConf[destIndex].getIaddr(), Constants.DATAGRAM_PORT);
			Server.dgram_socket.send(sendPacket);
		} catch (UnknownHostException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	private int allowedNumberOfObjects(Message sendMsg)
	{
		ByteArrayOutputStream baos = new ByteArrayOutputStream();

		try {
			ObjectOutputStream out = new ObjectOutputStream(baos);
			out.writeObject(sendMsg);
			out.close();
		}
		catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return ((64000 - baos.toByteArray().length)/3000);	//64000=assumed udp data size, 3000=assumed per record size
	}
	
	public void CommitGarbageCollection(int senderIndex, int gcNum)
	{
		if(Constants.IS_DEBUG_MODE) {
			System.out.println("Committing garbage collection");
		}
		
		HashMap<Integer, Integer> myStartVectorClock = Server.getStartVectorClockMap();
		
		if(Constants.IS_DEBUG_MODE) {
 			System.out.println("GCCOMMIT: Writing CHECKPOINT to file.");
 			}
		
		Server.updtTracker.removeUpdatesFromTo(senderIndex, myStartVectorClock.get(senderIndex), gcNum);
		Server.alterStartVectorClockMap(senderIndex, gcNum);
		Server.writeCheckpointToFile();
	}
}
