import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Date;


public class HeartBeat extends TimerTask{

	static int hbCount = 0;
	static int gcwakeupCount = 0;
	//TODO : Don't send any mesg if all at 0000
	// TODO: OPTIMIZE: should we send messages if there has been no change in the vector

	HeartBeat(){
	}

	synchronized boolean isSendKeepAlive()
	{
		hbCount++;
		if(hbCount == 2)
		{
			hbCount = 0;
			return true;
		}
		
		return false;
	}
	
	synchronized boolean isSendGCWakeUp()
	{
		gcwakeupCount++;
		if(gcwakeupCount == 10)
		{
			gcwakeupCount = 0;
			return true;
		}
		
		return false;
	}
	
	public void run(){

		if(Constants.IS_DEBUG_MODE)
			System.out.print("**");

		DatagramPacket packet;
		
		int myStartClk = Server.getMyStartClock();
		int myClk = Server.getMyClock();
		
		try {
			
			if(isSendKeepAlive())
			{
				Message msg = new Message();
				
				msg.setType(Message.Type.KEEPALIVE);
				msg.setSenderIndex(Server.myServerIndex);

				SendMulticastMessage(msg);
			}
			
			if(isSendGCWakeUp() && (myClk - myStartClk) > Constants.GCUPDATE_COUNT)
			{
				Server.gcResponseCount = 0;
				Server.gcUpdateNumber = myStartClk + Constants.GCUPDATE_COUNT;
				
				Message msg = new Message();
				
				msg.setType(Message.Type.GCREQUEST);
				msg.setGCUpdateNumber(Server.gcUpdateNumber);
				
				msg.setSenderIndex(Server.myServerIndex);
				
				if(Constants.IS_DEBUG_MODE) {
					System.out.println("Sending GCREQUEST message");
				}
	
				SendMulticastMessage(msg);
			}
			
			
			Message msg = new Message(Server.myServerIndex, null, Server.getVectorClockMap(), Message.Type.HEARTBEAT );
			
			ByteArrayOutputStream b_out = new ByteArrayOutputStream();
			ObjectOutputStream o_out = new ObjectOutputStream(b_out);
			o_out.writeObject(msg);
			byte[] buf = b_out.toByteArray();
			//  byte
			
			int nextServer = (Server.myServerIndex+1) % Constants.NUM_NODES;
			
			while(nextServer != (((Constants.NUM_NODES-1)+Server.myServerIndex) % Constants.NUM_NODES))
			{
				if(Server.serverConf[nextServer].isLive())
				{
					if(Constants.IS_DEBUG_MODE)
						System.out.println("Sending Heartbeat to "+nextServer);
					
					packet = new DatagramPacket(buf, buf.length, Server.serverConf[nextServer].getIaddr(), Constants.DATAGRAM_PORT);
					Server.dgram_socket.send(packet);
					break;
					//Thread.sleep(Constants.SLEEP_DELAY);
					//if((System.currentTimeMillis() - Server.serverConf[nextServer].getTstamp()) < Constants.SLEEP_DELAY)
					//{
					//}
				}
				if(Constants.IS_DEBUG_MODE)
					System.out.println("Server "+nextServer+"is dead");

				nextServer = (nextServer+1)%Constants.NUM_NODES; 
			}
			
		} catch (UnknownHostException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}
	
	public static void SendMulticastMessage(Message sendMsg)
	{
		DatagramPacket packet;
		MulticastSocket socket = null;
		
		try{
			socket = new MulticastSocket();
		} catch (IOException e) {
			e.printStackTrace();
		}

		try {
			ByteArrayOutputStream b_out = new ByteArrayOutputStream();
			ObjectOutputStream o_out = new ObjectOutputStream(b_out);
			o_out.writeObject(sendMsg);
			byte[] buf = b_out.toByteArray();
			//  byte
			packet = new DatagramPacket(buf, buf.length, InetAddress.getByName(Constants.MCAST_GROUP), Constants.MCAST_PORT);
			socket.send(packet);
		} catch (UnknownHostException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}finally 
		{
			socket.close();
		}
	}

}