import java.io.Serializable;
import java.util.HashMap;


public class MapValueEntry implements Serializable{
	public String data;
	public long tstamp;

	MapValueEntry(String inValue, long inTstamp)
	{
		data = inValue;
		tstamp = inTstamp;
	}
	
}

class Record implements Serializable{
	private String key;
	private MapValueEntry data;
	private int tableIndex;
	private int rowIndex;
	
	Record(String key, MapValueEntry data, int tableIndex, int rowIndex){
		this.key = key;
		this.data = data;
		this.tableIndex = tableIndex;
		this.rowIndex = rowIndex;
	}
	
	public String getKey() {
	 return key;
	}
	
	public MapValueEntry getMapValueEntry() {
	 return data;
	}
	
	public int getTableIndex() {
		return tableIndex;
	}
	
	public void setTableIndex(int tableIndex) {
		this.tableIndex = tableIndex;
	}
	
	public int getRowIndex() {
		return rowIndex;
	}
	
	public void setRowIndex(int rowIndex) {
		this.rowIndex = rowIndex;
	}
}