import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;

public class Message implements Serializable{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public enum Type {
		UPDATE, SYNC, HEARTBEAT, HYBRID, KEEPALIVE, GCREQUEST, GCRESPONSE, GCCOMMIT 
	}
	private ArrayList<Record> updateList;
	private HashMap<Integer,Integer> vectorClock;
	private Type type;
	private int senderIndex;
	private int gcUpdateNumber;
	//private int _myClock;

	public Message(){

	}

	public Message(int inSenderIndex, ArrayList<Record> updateList, HashMap<Integer,Integer> vectorClock, Type type ){
		this.senderIndex = inSenderIndex;
		this.updateList = updateList;
		this.vectorClock = vectorClock;
		this.type = type;
	}

	public Type getType() {
		return type;
	}

	public void setType(Type type) {
		this.type = type;
	}

	public int getSenderIndex() {
		return senderIndex;
	}

	public void setSenderIndex(int inSenderIndex) {
		this.senderIndex = inSenderIndex;
	}
	
	public int getGCUpdateNumber() {
		return gcUpdateNumber;
	}

	public void setGCUpdateNumber(int inGCNum) {
		this.gcUpdateNumber = inGCNum;
	}

	public ArrayList<Record> getUpdateList() {
		return updateList;
	}

	public void setUpdateList(ArrayList<Record> updateList) {
		this.updateList = updateList;
	}

	public HashMap<Integer,Integer> getVectorClock() {
		return vectorClock;
	}

	public void setVectorClock(HashMap<Integer,Integer> vectorClock) {
		this.vectorClock = vectorClock;
	}

	public void addEntry(Record entry)
	{
		updateList.add(entry);
	}

	public void removeEntry(Record entry)
	{
		updateList.remove(entry)	;	  
	}

	public void addAllEntriesFromCollection(ArrayList<Record> list)
	{
		updateList.addAll(list);
	}

	public void removeAllEntriesFromCollection(ArrayList<Record> list)
	{
		updateList.removeAll(list)	;	  
	}

	public void clearAll() {
		updateList.clear();	
	}
}
