import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.UnknownHostException;
import java.util.*;

public class MyKVMap implements Serializable{

	//TODO Change to HashTable (Loadfactor 0.75, Initialcapacity 50)
	//public static MyKVMap myKVMapObject;
	
	private static final long serialVersionUID = 1L;
	
	HashMap<String, MapValueEntry> mykvmap; 
	
	MyKVMap()
	{
		mykvmap = new HashMap<String, MapValueEntry>();
	}
	
	public synchronized MapValueEntry putValue(String key, MapValueEntry invalue)
	{
		MapValueEntry myVal = mykvmap.get(key);
		
		if(myVal == null)
			return mykvmap.put(key, invalue);
		else if(myVal.tstamp < invalue.tstamp)
		{
			return mykvmap.put(key, invalue);
		}
		
		return myVal;
	}
	
	public synchronized void removeKey(String key)
	{
		mykvmap.remove(key);
	}
	
	public synchronized MapValueEntry getValue(String key)
	{
		return mykvmap.get(key);
	}
	
	public synchronized void checkpointKVMapAndVectorClock()
	{
		//will save start vector clock map only...i will receive rest of the updates from other nodes
		//because if i save higher vector clock map then i also need to have updates corresponding to them
		
		HashMap<Integer, Integer> chkptVectorClock = Server.getStartVectorClockMap();
		File file =new File(Constants.CHECKPOINT_FILE);
		if(file.exists())
			file.delete();
		
		try {
			file.createNewFile();
			FileOutputStream fos = new FileOutputStream(file);
			ObjectOutputStream oos = new ObjectOutputStream(fos);
			oos.writeObject(this);
			oos.writeObject(chkptVectorClock);
			
			if(Constants.IS_DEBUG_MODE) {
				System.out.println("Writing CHECKPOINT to file.");
				System.out.print("VCMap writing:");
				for(int i=0; i<Constants.NUM_NODES; i++) {
					System.out.print(" " + chkptVectorClock.get(i));
				}
				System.out.println();
			}
			
			oos.flush();
		    oos.close();
			fos.close();
		} catch (UnknownHostException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public synchronized void uncheckpointKVMapAndVectorClock(MyKVMap inkvmap, HashMap<Integer, Integer> inVClockMap)
	{
		HashMap<Integer, Integer> startVCMap = Server.getStartVectorClockMap();
		Server.setStartVectorClockMap(inVClockMap);
		Server.syncVectorCMapAndStartVectorCMap(inVClockMap);
		
		//remove all unnecessary updates
		for(int i=0; i<Constants.NUM_NODES; i++) {
			if(inVClockMap.get(i) != -1)
			{
				if(inVClockMap.get(i) > startVCMap.get(i))
				{
					for(int j= startVCMap.get(i); j<=inVClockMap.get(i); j++) {
						Server.updtTracker.removeUpdate(i, j);
					}
				}
			}
		}
		
		Iterator iterator = inkvmap.mykvmap.keySet().iterator();
		
		while (iterator.hasNext()) {
			String key = (String) iterator.next();
			MapValueEntry val = inkvmap.getValue(key);
			mykvmap.put(key, val);
		}
		
		if(Constants.IS_DEBUG_MODE) {
		  System.out.println("After uncheckpointing");
		  Server.printVectorClockMaps();
		  }
	}
}