import java.io.*;
import java.net.*;
import java.util.concurrent.Executors;
import java.util.concurrent.ExecutorService;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Timer;

//sighandler tp
import sun.misc.Signal;
import sun.misc.SignalHandler;


class Server implements SignalHandler
{
	private static String[] servers;
	private static int[] ports;
	static int myServerIndex;

	static int gcUpdateNumber = -1;								//initially 0;
	static int gcResponseCount = 0;								//set to 0 when outstanding gcrequest 
	static ServerConf[] serverConf;
	static UpdateTracker updtTracker;
	static DatagramSocket dgram_socket = null;
	static MyKVMap kvmap;
	private static int myPort = 0;
	private static HashMap<Integer, Integer> vectorClockMap;	//initially -1
	
	//TODO: WHENEVER CHANGE START VECTOR CLOCK, CHECKPOINT IT
	private static HashMap<Integer, Integer> startVectorClockMap;	//initially -1
	private static MulticastSocket  mcast_socket_rcv  = null;
	//sighandler tp
	private SignalHandler oldSigHandler;
	
	public static void main(String[] a) throws Exception {
		servers = new String[Constants.NUM_NODES];
		ports = new int[4];
		myServerIndex = 0;
		
		serverConf = new ServerConf[Constants.NUM_NODES];
		vectorClockMap = new HashMap<Integer, Integer>();
		startVectorClockMap = new HashMap<Integer, Integer>();
		
		dgram_socket = new DatagramSocket();
		updtTracker = new UpdateTracker();
		kvmap = new MyKVMap();

		initConfiguration();  

		String myIpAddr = null;
		String myHostname = null;
		
		InetAddress addr = serverConf[myServerIndex].getIaddr();
		myIpAddr = addr.getHostAddress();
		myHostname = addr.getHostName();

		System.out.println("me:"+myServerIndex);
		System.out.println("Server "+myHostname+" Starts at "+myIpAddr+":"+myPort);

		Timer backgTimer = new Timer();
		backgTimer.schedule(new HeartBeat(), 0, Constants.HEARTBEAT_DELAY);

		//Listener for multicast socket
		new Thread() {
			public void run() {
				ExecutorService _threadExecutor = Executors.newFixedThreadPool(Constants.NUM_THREADS);

				if(Constants.IS_DEBUG_MODE)
					System.out.println(Thread.currentThread().getName()+" - new backchannel listener thread created");

				try {
					if(Constants.IS_DEBUG_MODE)
						System.out.println("Server: Now doing my Multicast business: Joining Group");

					mcast_socket_rcv = new MulticastSocket(Constants.MCAST_PORT);
					mcast_socket_rcv.setLoopbackMode(true);
					mcast_socket_rcv.setReuseAddress(Constants.IS_SOCKET_REUSE_ADDRESS);
					//mcast_socket_rcv.Set
					InetAddress group = InetAddress.getByName(Constants.MCAST_GROUP);
					mcast_socket_rcv.joinGroup(group);

					while(true)  {
						byte[] buf = new byte[Constants.DATAGRAM_MAX];
						DatagramPacket dgram = new DatagramPacket(buf, buf.length);
						mcast_socket_rcv.receive(dgram);
						BackchannelListener listener = new BackchannelListener(buf);
						_threadExecutor.execute(listener);
					}
				}
				catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}.start();
		
		//socket for client requests
		new Thread() {
			public void run() {
				ExecutorService threadExecutor = Executors.newFixedThreadPool(Constants.NUM_THREADS);

				if(Constants.IS_DEBUG_MODE)
					System.out.println(Thread.currentThread().getName()+" --- new server thread created");

				ServerSocket serverSock;
				try {
					serverSock = new ServerSocket(myPort);	         
					while (true) 
					{
						Socket sock = serverSock.accept();
						sock.setReuseAddress(Constants.IS_SOCKET_REUSE_ADDRESS);
						Worker worker = new Worker(sock);
						threadExecutor.execute(worker);
					}
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}.start();
		
		//socket for checkpoint receive
		new Thread() {
			public void run() {
				//TODO = check if port binding succeeded
				// ServerSocket serverSock = new ServerSocket(Integer.parseInt(a[0]));
				ServerSocket serverSock = null;
				ObjectInputStream ois = null;
				boolean sendCheckpoint = false;
				try {
					serverSock = new ServerSocket(Constants.CHECKPOINT_PORT);	         
					while (true) 
					{
						Socket sock = serverSock.accept();
						receiveCheckpointIntoLocalState(sock);
						sock.close();
					}
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}.start();
		//threadExecutor.shutdown();
	}


	private static void initConfiguration() {
		if(Constants.IS_DEBUG_MODE)
			System.out.println("Server: Now Installing Signals");
		
		//sighandler tp
		Server.install("TERM");
		Server.install("INT");

		if(Constants.IS_DEBUG_MODE)
			System.out.println("Server: Now Reading Servers File");
		readServersFile();
		
		readCoreDump();	 

		return;
	}

	private static void readCoreDump() {
		//read checkpoint if exists
		HashMap<Integer, Integer> readCheckpointVectorClock = new HashMap<Integer, Integer>();
		MyKVMap readCheckpointKVMap = Server.readCheckpointFromFile(readCheckpointVectorClock);
		
		if(readCheckpointKVMap != null)
		{
			if(Constants.IS_DEBUG_MODE)
				System.out.println("Reading Checkpoint");
			kvmap.uncheckpointKVMapAndVectorClock(readCheckpointKVMap, readCheckpointVectorClock);
		}
	}

	private static void readServersFile()
	{
		int i = 0;
		try
		{
			FileInputStream fstream = new FileInputStream(Constants.SERVERS_FILE);
			DataInputStream dis = new DataInputStream(fstream);
			BufferedReader br = new BufferedReader(new InputStreamReader(dis));
			String strLine = null, tempString = null;
			int tempInt = 0;

			i = 0;
			//TODO: Shouldn't it read more than 4 lines for scalability?
			while((strLine = br.readLine()) != null && i < Constants.NUM_NODES)
			{
				servers[i] = strLine.substring(0, strLine.indexOf(':'));
				ports[i] = Integer.parseInt(strLine.substring(strLine.indexOf(':')+1, strLine.length()));


				if(i==0) {
					myPort = ports[i];
				}
				i++;
			}

			dis.close();

			for(i = 0; i < Constants.NUM_NODES-1; i++)
			{
				for(int j = i+1; j < Constants.NUM_NODES; j++)
				{
					if((servers[i]+ports[i]).compareTo(servers[j]+ports[j]) > 0)
					{
						if(myServerIndex == i)
							myServerIndex = j;
						else if(myServerIndex == j)
							myServerIndex = i;

						tempString = servers[j];
						tempInt = ports[j];

						servers[j] = servers[i];
						ports[j] = ports[i];

						servers[i] = tempString;
						ports[i] = tempInt;
					}
				}
			}

			//Initialize vector clocks
			if(Constants.IS_DEBUG_MODE)
				System.out.println("Server: Now Initializing Vector Clocks");

			for(i=0;i<Constants.NUM_NODES;i++) {
				serverConf[i] = new ServerConf();
				serverConf[i].setPort(ports[i]);
				serverConf[i].setIaddr(InetAddress.getByName(servers[i]));
				serverConf[i].setTstamp(System.currentTimeMillis());
				vectorClockMap.put(i, -1);
				startVectorClockMap.put(i, -1);
			}

			if(Constants.IS_DEBUG_MODE) {
				for(i = 0; i < Constants.NUM_NODES; i++)
				{
					System.out.println("server["+i+"]=" + servers[i] + " port["+i+"]=" + ports[i]);
				}
			}
		}
		catch(FileNotFoundException e)
		{
			System.out.println("File "+Constants.SERVERS_FILE+" Not Found");
			System.exit(1);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}

	private static void printState() {
		//TODO print the current state of the sever
		// clock and keyvaluestore
		return;
	}
	
	//sighandler tp
	private static SignalHandler install(String signalName) {
		Signal diagSignal = new Signal(signalName);
		Server instance = new Server();
		instance.oldSigHandler = Signal.handle(diagSignal, instance);
		return instance;
	}

	public void handle(Signal signal) {
		if(Constants.IS_DEBUG_MODE)
			System.out.println("Signal handler called for signal "+ signal);
		try {
			signalAction(signal);
			// Chain back to previous handler, if one exists
			if (oldSigHandler != SIG_DFL && oldSigHandler != SIG_IGN) {
				oldSigHandler.handle(signal);
			}

		} catch (Exception e) {
			System.out.println("Signal handler failed " + e.getMessage());
			e.printStackTrace();
		}
	}

	public void signalAction(Signal signal) {
		if(Constants.IS_DEBUG_MODE){
			System.out.println("Server: Handling " + signal.getName());
			System.out.println("Saving State");
		}

		writeCheckpointToFile();
	}

	public static synchronized int incrementSelfClock(int x) {
		int myClock = vectorClockMap.get(Server.myServerIndex);
		
		if(Constants.IS_DEBUG_MODE)
			System.out.println("Server: Clock:[old = "+myClock+"]");
		myClock = myClock + x;
		
		vectorClockMap.put(myServerIndex, myClock);
		
		if(Constants.IS_DEBUG_MODE)
			System.out.println("Server: Clock:[new = "+myClock+"]");
	
		return myClock;
	}

	public static synchronized int updateClock(int table, int x) {
		int curClock = vectorClockMap.get(table);

		if(Constants.IS_DEBUG_MODE)
			System.out.println("Table:"+ table +" Clock:old = "+curClock);

		if((curClock+1) == x)
		{
			vectorClockMap.put(table, x);
			curClock = x;
		}

		if(Constants.IS_DEBUG_MODE)
			System.out.println("Table:"+ table +" Clock:new = "+ curClock);

		return curClock;
	}

	public static MulticastSocket getMultiCastSocket() {
		return mcast_socket_rcv;
	}

	public static int getMyClock() {
		return vectorClockMap.get(Server.myServerIndex);
	}

	public static int getMyStartClock() {
		return startVectorClockMap.get(Server.myServerIndex);
	}
	
	public static ServerConf[] getServerConf() {
		return serverConf;
	}

	public static HashMap<Integer, Integer> getVectorClockMap() {
		return vectorClockMap;
	}
	
	public static void setVectorClockMap(HashMap<Integer, Integer> inVClockMap) {
		for(int i=0; i<Constants.NUM_NODES; i++) {
			vectorClockMap.put(i, inVClockMap.get(i));
		}
	}
	
	public static void printVectorClockMaps() {
		System.out.print("VClock: "); 
		for(int i=0; i<Constants.NUM_NODES; i++) {
			System.out.print(vectorClockMap.get(i)+" "); 
		}
		System.out.print("StartVClock: ");
		for(int i=0; i<Constants.NUM_NODES; i++) {
			System.out.print(startVectorClockMap.get(i)+" "); 
		}
	}
	public static void syncVectorCMapAndStartVectorCMap(HashMap<Integer, Integer> startVClockMap) {
		for(int i=0; i<Constants.NUM_NODES; i++) {
			if(startVClockMap.get(i) != -1)
			{
				if(startVClockMap.get(i) > vectorClockMap.get(i))
					vectorClockMap.put(i, startVClockMap.get(i)); 
			}
		}
	}
	
	public static HashMap<Integer, Integer> getStartVectorClockMap() {
		return startVectorClockMap;
	}
	
	public static void setStartVectorClockMap(HashMap<Integer, Integer> inVClockMap) {
		for(int i=0; i<Constants.NUM_NODES; i++) {
			startVectorClockMap.put(i, inVClockMap.get(i));
		}
	}

	public static void alterStartVectorClockMap(int tableIndex, int startNum) {
		startVectorClockMap.put(tableIndex, startNum);
	}

	public static void writeCheckpointToFile()
	{
		kvmap.checkpointKVMapAndVectorClock();
		
		  if(Constants.IS_DEBUG_MODE) {
		    System.out.println("After writing checkpoint");
		    Server.printVectorClockMaps();
		  }
	}

	public static MyKVMap readCheckpointFromFile(HashMap<Integer, Integer> inVectorClock)
	{
		int i=0;
	
		File file = new File(Constants.CHECKPOINT_FILE);
		
		if(!file.exists())
			return null;
			
		MyKVMap chkptKVMap = null;
		HashMap<Integer, Integer> chkptVectorClock = null;
		
		try {
			FileInputStream fis = new FileInputStream(file);
			ObjectInputStream ois = new ObjectInputStream(fis);
			chkptKVMap = (MyKVMap) ois.readObject();
			chkptVectorClock = (HashMap<Integer, Integer>) ois.readObject();
			
			if(inVectorClock != null)
			{
				for(i=0; i<Constants.NUM_NODES; i++) {
					inVectorClock.put(i, chkptVectorClock.get(i));
				}
			}
			
			if(Constants.IS_DEBUG_MODE) {
				System.out.println("Reading CHECKPOINT from file.");
				System.out.print("VCMap reading:");
				for(i=0; i<Constants.NUM_NODES; i++) {
					System.out.print(" " + chkptVectorClock.get(i));
				}
				System.out.println();
			}
			
			ois.close();
		    fis.close();
	    } catch (UnknownHostException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return chkptKVMap;
	}

	public static void sendCheckpoint(MyKVMap chkptKVMap, HashMap<Integer, Integer> chkptVectorClock, int destIndex)
	{
		if(Constants.IS_DEBUG_MODE) {
 			System.out.println("Sending CHECKPOINT to " + destIndex);
 			}
		
		Socket socket = null;
		ObjectOutputStream oos = null;
		
		try {
			socket = new Socket(Server.serverConf[destIndex].getIaddr(), Constants.CHECKPOINT_PORT);
			socket.setTcpNoDelay(Constants.IS_TCP_NODELAY);
			oos = new ObjectOutputStream(socket.getOutputStream());
			oos.writeObject(chkptKVMap);
			oos.writeObject(chkptVectorClock);
			oos.flush();
	        oos.close();
	        socket.close();
		} catch (UnknownHostException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	private static void receiveCheckpointIntoLocalState(Socket sock)
	{
		ObjectInputStream ois = null;
		MyKVMap chkptKVMap = null;
		HashMap<Integer, Integer> chkptVectorClock = null;
		boolean receiveCheckpoint = false;
		
		try {
			ois = new ObjectInputStream(sock.getInputStream());
			chkptKVMap = (MyKVMap) ois.readObject();
			chkptVectorClock = (HashMap<Integer, Integer>) ois.readObject(); 
			
			HashMap<Integer, Integer> myStartVCMap = getStartVectorClockMap();
			
			for(int i=0; i<Constants.NUM_NODES; i++) {
				if(myStartVCMap.get(i) < chkptVectorClock.get(i))
				{
					receiveCheckpoint = true;
					break;
				}
			}
			
			if(!receiveCheckpoint)
			{
				return;		//already received checkpoint
			}
			
			if(Constants.IS_DEBUG_MODE) {
				System.out.println("Received CHECKPOINT.....");
				System.out.print("VCMap reading:");
				for(int i=0; i<Constants.NUM_NODES; i++) {
					System.out.print(" " + chkptVectorClock.get(i));
				}
				System.out.println();
			}
			
			ois.close();
			//sock.close();
		} catch (UnknownHostException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		//write to file so that I can send it to other nodes just by reading it from my file
		writeReceivedCheckpointToFile(chkptKVMap, chkptVectorClock);
		kvmap.uncheckpointKVMapAndVectorClock(chkptKVMap, chkptVectorClock);
	}
	
	public static void writeReceivedCheckpointToFile(MyKVMap chkptKVMap, HashMap<Integer, Integer> chkptVectorClock)
	{
		File file =new File(Constants.CHECKPOINT_FILE);
		if(file.exists())
			file.delete();
		
		try {
			file.createNewFile();
			FileOutputStream fos = new FileOutputStream(file);
			ObjectOutputStream oos = new ObjectOutputStream(fos);
			oos.writeObject(chkptKVMap);
			oos.writeObject(chkptVectorClock);
			
			if(Constants.IS_DEBUG_MODE) {
				System.out.println("Writing received CHECKPOINT to file.");
				System.out.print("VCMap writing:");
				for(int i=0; i<Constants.NUM_NODES; i++) {
					System.out.print(" " + chkptVectorClock.get(i));
				}
				System.out.println();
			}
			
			oos.flush();
		    oos.close();
			fos.close();
		} catch (UnknownHostException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}