import java.util.*;

public class UpdateTracker {

	MyUpdateMap[] updateTable; 

	UpdateTracker()
	{
		updateTable = new MyUpdateMap[Constants.NUM_NODES];
		for(int i=0; i<Constants.NUM_NODES; i++)
		{
			updateTable[i] = new MyUpdateMap();
		}
	}

	public synchronized void insertUpdate(int tableIndex, int row, String update)
	{
		if(Constants.IS_DEBUG_MODE)
			System.out.println("New Update:" + update + " at " + row + " for table: " + tableIndex);
		
		updateTable[tableIndex].putValue(row, update);
		
	}

	public String getUpdate(int tableIndex, int row)
	{
			return updateTable[tableIndex].getValue(row);
	}
	
	public void removeUpdate(int tableIndex, int row)
	{
			updateTable[tableIndex].removeKey(row);
	}
	
	public void removeUpdatesFromTo(int tableIndex, int from, int to)
	{
		for(int i= from; i <= to; i++) {
			updateTable[tableIndex].removeKey(i);
		}
	}

}

class MyUpdateMap {

	//TODO Change to HashTable (Loadfactor 0.75, Initialcapacity 50)
	//public static MyKVMap myKVMapObject;
	
	HashMap<Integer, String> myupdatemap; 
	
	MyUpdateMap()
	{
		myupdatemap = new HashMap<Integer, String>();
	}

	public synchronized String putValue(Integer row, String value)
	{
		return myupdatemap.put(row, value);
	}
	
	public synchronized void removeKey(Integer key)
	{
		myupdatemap.remove(key);
	}
	
	public synchronized String getValue(Integer key)
	{
		return myupdatemap.get(key);
	}
}