import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;

class Worker implements Runnable {
    

    byte[] buf;
    private Socket wrkSocket;
    
    Worker(Socket socket) 
    {
        buf = new byte[Constants.BUF_SIZE];
        wrkSocket = socket;
    }

    public void run() {
    	try
    	{
    		handleClient();
    		if(Constants.IS_DEBUG_MODE)
    			System.out.println("Now sending updates");
    	}
    	catch(Exception e)
    	{
    		e.printStackTrace();
    	}
    }

    private void sendUpdates(Message msg) {
    	
    	if(Constants.IS_DEBUG_MODE)
			System.out.println("In sendUpdate");
    	
		//Multicast version follows
    	DatagramPacket packet;
    	
    	//TODO  May be we should re-use the socket.
    	MulticastSocket socket = null;
    	try{
    	     socket = new MulticastSocket();
			} catch (IOException e) {
				e.printStackTrace();
			}
		
    	
    	try {
    	 ByteArrayOutputStream b_out = new ByteArrayOutputStream();
    	 ObjectOutputStream o_out = new ObjectOutputStream(b_out);
    	 o_out.writeObject(msg);
    	 byte[] buf = b_out.toByteArray();
        //  byte
			packet = new DatagramPacket(buf, buf.length, InetAddress.getByName(Constants.MCAST_GROUP), Constants.MCAST_PORT);
			socket.send(packet);
		} catch (UnknownHostException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}finally 
		{
			socket.close();
		}
    	
	}

	private void handleClient() throws IOException
    {
    	BufferedInputStream instream = null;
    	PrintStream outstream = null;
    	int row = 0;
    	
    	try
    	{
    		instream = new BufferedInputStream (wrkSocket.getInputStream());
    		outstream = new PrintStream(wrkSocket.getOutputStream());
    	}
    	catch (UnknownHostException e) {
            return;
        } catch (IOException e) {
            e.printStackTrace();
            return;
        }
        
        //wrkSocket.setSoTimeout(Server.timeout);
        wrkSocket.setTcpNoDelay(Constants.IS_TCP_NODELAY);
        
        try
        {
        	//TODO
        	//
        	// Need to send HTTP/1.0 500 Internal Server Error
        	// in case the input from client is malformed
        	// or due to any other error
        	//
        	
            if(instream.read(buf, 0, Constants.BUF_SIZE) == -1) {
            	System.out.println("ERROR:r is -1");
                sendError(outstream, "Invalid Input");
            }
                
            String message = new String(buf);
            if(Constants.IS_DEBUG_MODE)
                System.out.println("Got Message from Client:"+ message);
            
            MapValueEntry mValueEntry = null, mUpdateEntry = null;
            String inpkey = null, inpValue = null;
            int indexEqual, indexStart, indexEnd;
            
            indexStart =  message.indexOf('[');
            indexEnd = message.indexOf(']') ;
            
            if(indexStart == -1 || indexEnd == -1 || indexEnd < indexStart)
            {
            	sendError(outstream, "Invalid Message "+message);
                return;
            }
            
            message = message.substring(message.indexOf('['), message.lastIndexOf(']')+1);
            
            indexStart =  message.indexOf('[');
            indexEnd = message.indexOf(']') ;
            
            inpkey = message.substring(indexStart+1, indexEnd);
            
            indexEqual = message.indexOf('=');
            if(indexEqual != -1)
            {
            	inpValue = message.substring(indexEqual+1);
            	
            	indexStart =  inpValue.indexOf('[');
                indexEnd = inpValue.indexOf(']');
                
                if(indexStart == -1 || indexEnd == -1 || indexEnd < indexStart)
                {
                	sendError(outstream, "Invalid_Message " + message);
                    return;
                }
                if (indexStart != inpValue.lastIndexOf('[') || indexEnd != inpValue.lastIndexOf(']'))
                {
                	sendError(outstream, "Invalid Message "+ message);
                    return;
                }
                
                inpValue = inpValue.substring(1, inpValue.length()-1);
                
            	mValueEntry = new MapValueEntry(inpValue, System.currentTimeMillis());
            	MapValueEntry rcvValEntry = mValueEntry;
            	
            	mValueEntry = Server.kvmap.putValue(inpkey, mValueEntry);
            	
            	row = updateMyClock();
            	
            	Server.updtTracker.insertUpdate(Server.myServerIndex, row, inpkey);
            	 
            	 Message msg = new Message();
            	 msg.setType(Message.Type.UPDATE);
            	 msg.setSenderIndex(Server.myServerIndex);
            	 msg.setVectorClock(Server.getVectorClockMap());
            	 
            	 ArrayList<Record> arr = new ArrayList<Record>();
            	 arr.add(new Record(inpkey,rcvValEntry, Server.myServerIndex, row));
            	 
            	 if(Constants.IS_DEBUG_MODE)
            		 System.out.println("Records sent="+arr.size());
            	
            	msg.setUpdateList(arr);
            	 
            	 if(Constants.IS_DEBUG_MODE) {
         			System.out.println("Now sending updates");
         			}
            	 
        		sendUpdates(msg);
        	   
        		if(Constants.IS_DEBUG_MODE) {
        		  System.out.println("After sending updates");
        		  Server.printVectorClockMaps();
        	   }
            }
            else if (indexStart != message.lastIndexOf('[') || indexEnd != message.lastIndexOf(']'))
            {
            	sendError(outstream, "Invalid Key "+ inpkey);
                return;
            }
            else
            {
            	mValueEntry = Server.kvmap.getValue(inpkey);
            }
            
            if(mValueEntry != null)
        		inpValue = mValueEntry.data;
        	else
        		inpValue = null;
            
            if(Constants.IS_DEBUG_MODE)
            	System.out.println("key:"+ inpkey);
            
            outstream.println("HTTP/1.0 200 OK");
            outstream.println("Server: " + Server.myServerIndex);
            outstream.println("Content-Length: " + (inpkey + inpValue).length());
            outstream.println("Content-Type: text/plain");
            
            outstream.print("[" + inpkey + "]" + "=");
            if(inpValue != null)
            	outstream.println("["+ inpValue + "]");
            else
            	outstream.println("NIL");
            outstream.flush();
        }
        catch(IOException e)
        {
        	e.printStackTrace();
        	sendError(outstream, "Internal Server Error : "+e.getMessage());
        }
        finally 
        {
        	wrkSocket.close();
        	instream.close();
        	outstream.close();
        }
    }

	private void sendError(PrintStream outstream, String errorMessage) {
		outstream.print("HTTP/1.0 500 ");
		outstream.println("ERROR: " + errorMessage);
		outstream.flush();
	}
	
	private int updateMyClock() {
		return Server.incrementSelfClock(1);
	}
}
