
package blather.tests;

import org.junit.*;
import static org.junit.Assert.*;
import blather.model.EmailAddress;

public final class EmailAddressTest {
    EmailAddress ea;
    
	@Before
	public void fixtureSetup() { ea = new EmailAddress("bogus@address.com"); }

	@After
	public void fixtureTeardown() { ea = null; }

    @Test(expected=blather.exceptions.BogusParameterException.class)
    public void badSet() {
        ea.setEmail("bogusaddress.com");
    }
    
    @Test
    public void badAddress0() {
        final String BAD_ADDR = "argh";
        assertFalse("'" + BAD_ADDR + "' should not be valid by EmailAddress.isValid", EmailAddress.isValid(BAD_ADDR));
    }
    
    @Test
    public void badAddress1() {
        final String BAD_ADDR = "fooATblah.com";
        assertFalse("'" + BAD_ADDR + "' should not be valid by EmailAddress.isValid", EmailAddress.isValid(BAD_ADDR));
    }
    
    @Test
    public void badAddress2() {
        final String BAD_ADDR = "foo@blah";
        assertFalse("'" + BAD_ADDR + "' should not be valid by EmailAddress.isValid", EmailAddress.isValid(BAD_ADDR));
    }
    
    @Test
    public void badAddress3() {
        final String BAD_ADDR = "@.";
        assertFalse("'" + BAD_ADDR + "' should not be valid by EmailAddress.isValid", EmailAddress.isValid(BAD_ADDR));
    }
    
    @Test
    public void badAddress4() {
        final String BAD_ADDR = "foo@@blah.com";
        assertFalse("'" + BAD_ADDR + "' should not be valid by EmailAddress.isValid", EmailAddress.isValid(BAD_ADDR));
    }

    @Test
    public void badAddress6() {
        final String BAD_ADDR = "a@.c";
        assertFalse("'" + BAD_ADDR + "' should not be valid by EmailAddress.isValid", EmailAddress.isValid(BAD_ADDR));
        }
    
    @Test
    public void badAddress7() {
        final String BAD_ADDR = "a@c.";
        assertFalse("'" + BAD_ADDR + "' should not be valid by EmailAddress.isValid", EmailAddress.isValid(BAD_ADDR));
    }
    
    @Test
    public void badAddress8() {
        final String BAD_ADDR = "@c.d";
        assertFalse("'" + BAD_ADDR + "' should not be valid by EmailAddress.isValid", EmailAddress.isValid(BAD_ADDR));
        }
    
    @Test
    public void badAddress9() {
        final String BAD_ADDR = "@c";
        assertFalse("'" + BAD_ADDR + "' should not be valid by EmailAddress.isValid", EmailAddress.isValid(BAD_ADDR));
        }
    
    @Test
    public void badAddress10() {
        final String BAD_ADDR = "@.d";
        assertFalse("'" + BAD_ADDR + "' should not be valid by EmailAddress.isValid", EmailAddress.isValid(BAD_ADDR));
        }
    
    @Test
    public void badAddress11() {
        final String BAD_ADDR = "a@a..b";
        assertFalse("'" + BAD_ADDR + "' should not be valid by EmailAddress.isValid", EmailAddress.isValid(BAD_ADDR));
        }
    
    @Test
    public void badAddress12() {
        final String BAD_ADDR = "a@";
        assertFalse("'" + BAD_ADDR + "' should not be valid by EmailAddress.isValid", EmailAddress.isValid(BAD_ADDR));
        }
    
    @Test
    public void badAddress13() {
        final String BAD_ADDR = "a@...";
        assertFalse("'" + BAD_ADDR + "' should not be valid by EmailAddress.isValid", EmailAddress.isValid(BAD_ADDR));
        }
    
    @Test
    public void badAddress14() {
        final String BAD_ADDR = "a@...a.f";
        assertFalse("'" + BAD_ADDR + "' should not be valid by EmailAddress.isValid", EmailAddress.isValid(BAD_ADDR));
        }
    
    @Test
    public void goodAddress4() {
        final String GOOD_ADDR = ".@foo.bar";
        assertTrue("'" + GOOD_ADDR + "' should be valid by EmailAddress.isValid", EmailAddress.isValid(GOOD_ADDR));
        }
    
    @Test
    public void badAddress16() {
        final String BAD_ADDR = "this-is-a-very-long-address.isnt-it@some.domain.with.a.whole.bunch.of.periods.including.a.terminal.one.";
        assertFalse("'" + BAD_ADDR + "' should not be valid by EmailAddress.isValid", EmailAddress.isValid(BAD_ADDR));
    }
    
    @Test
    public void goodAddress0() {
        final String GOOD_ADDR = "this-is-a-very-long-address.isnt-it@some.domain.with.a.whole.bunch.of.periods.excluding.a.terminal.one";
        assertTrue("'" + GOOD_ADDR + "' should be valid by EmailAddress.isValid", EmailAddress.isValid(GOOD_ADDR));
        }
    
    @Test
    public void goodAddress1() {
        final String GOOD_ADDR = "foo@bar.com";
        assertTrue("'" + GOOD_ADDR + "' should be valid by EmailAddress.isValid", EmailAddress.isValid(GOOD_ADDR));
        }
    
    @Test
    public void goodAddress2() {
        final String GOOD_ADDR = "f.o.o@b.a.r.c.o.m.com";
        assertTrue("'" + GOOD_ADDR + "' should be valid by EmailAddress.isValid", EmailAddress.isValid(GOOD_ADDR));
        }
    
    @Test
    public void goodAddress3() {
        final String GOOD_ADDR = "foo.bar.jr@bar.co";
        assertTrue("'" + GOOD_ADDR + "' should be valid by EmailAddress.isValid", EmailAddress.isValid(GOOD_ADDR));
    }
    
    @Test
    public void testDisplayEmail1() {
        final String INPUT = "fred@bedrock.gov";
        final String EXPECTED = "fred@b...gov";
        ea = new EmailAddress(INPUT);
        
        assertTrue("getDisplayEmail() appears to be broken with input " + INPUT, ea.getDisplayEmail().equals(EXPECTED));
    }

    @Test
    public void testDisplayEmail2() {
        final String INPUT = "fred@b.g";
        final String EXPECTED = "fred@b...g";
        ea = new EmailAddress(INPUT);
        
        assertTrue("getDisplayEmail() appears to be broken with input " + INPUT, ea.getDisplayEmail().equals(EXPECTED));
    }
    
    @Test
    public void testDisplayEmail3() {
        final String INPUT = "fred.flintstone@service.subdomain.domain.com";
        final String EXPECTED = "fred.flintstone@s...com";
        ea = new EmailAddress(INPUT);
        
        assertTrue("getDisplayEmail() appears to be broken with input " + INPUT, ea.getDisplayEmail().equals(EXPECTED));
    }
    
    @Test
    public void testGetEmail() {
        final String INPUT = "fred@b.g";
        
        ea = new EmailAddress(INPUT);
        
        assertTrue("getEmail() doesn't return proper value", ea.getEmail().equals(INPUT));
    }

    @Test
    public void testToString() {
        final String INPUT = "fred@b.g";
        
        ea = new EmailAddress(INPUT);
        
        assertTrue("toString() doesn't return proper value", ea.toString().equals(INPUT));
    }
    
}