package blather.tests;

import org.junit.runner.notification.Failure;
import org.junit.runner.JUnitCore;
import org.junit.runner.notification.RunListener;

public final class RunModelTests {
    public static class FailurePrinter extends RunListener
    {
        public void testFailure (Failure f) {
            System.err.println(f.getTestHeader() + " FAILED:  " + f.getException());
        }
    }
    
    
    public static void main(String[] args) {
        JUnitCore core = new JUnitCore();
        core.addListener(new FailurePrinter());
        core.run(blather.tests.EmailAddressTest.class, blather.tests.BlatherUserTester.class);

        System.out.println("All model tests done; any failures are reported above.");
    }
}
