/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.portmap;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.RpcAcceptedReply;
import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.RpcInfo;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.oncrpc.RpcResponse;
import org.apache.hadoop.oncrpc.RpcUtil;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.VerifierNone;
import org.apache.hadoop.portmap.PortmapInterface;
import org.apache.hadoop.portmap.PortmapMapping;
import org.apache.hadoop.portmap.PortmapRequest;
import org.apache.hadoop.portmap.PortmapResponse;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;

public class RpcProgramPortmap
extends RpcProgram
implements PortmapInterface {
    public static final int PROGRAM = 100000;
    public static final int VERSION = 2;
    private static final Log LOG = LogFactory.getLog(RpcProgramPortmap.class);
    private final HashMap<String, PortmapMapping> map = new HashMap(256);

    public RpcProgramPortmap() {
        super("portmap", "localhost", 111, 100000, 2, 2);
    }

    private synchronized void dumpRpcServices() {
        Set<Map.Entry<String, PortmapMapping>> entrySet = this.map.entrySet();
        for (Map.Entry<String, PortmapMapping> entry : entrySet) {
            LOG.info((Object)("Service: " + entry.getKey() + " portmapping: " + entry.getValue()));
        }
    }

    @Override
    public XDR nullOp(int xid, XDR in, XDR out) {
        return PortmapResponse.voidReply(out, xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XDR set(int xid, XDR in, XDR out) {
        PortmapMapping mapping = PortmapRequest.mapping(in);
        String key = PortmapMapping.key(mapping);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Portmap set key=" + key));
        }
        PortmapMapping value = null;
        RpcProgramPortmap rpcProgramPortmap = this;
        synchronized (rpcProgramPortmap) {
            this.map.put(key, mapping);
            this.dumpRpcServices();
            value = this.map.get(key);
        }
        return PortmapResponse.intReply(out, xid, value.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized XDR unset(int xid, XDR in, XDR out) {
        PortmapMapping mapping = PortmapRequest.mapping(in);
        RpcProgramPortmap rpcProgramPortmap = this;
        synchronized (rpcProgramPortmap) {
            this.map.remove(PortmapMapping.key(mapping));
        }
        return PortmapResponse.booleanReply(out, xid, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized XDR getport(int xid, XDR in, XDR out) {
        PortmapMapping mapping = PortmapRequest.mapping(in);
        String key = PortmapMapping.key(mapping);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Portmap GETPORT key=" + key + " " + mapping));
        }
        PortmapMapping value = null;
        RpcProgramPortmap rpcProgramPortmap = this;
        synchronized (rpcProgramPortmap) {
            value = this.map.get(key);
        }
        int res = 0;
        if (value != null) {
            res = value.getPort();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found mapping for key: " + key + " port:" + res));
            }
        } else {
            LOG.warn((Object)("Warning, no mapping for key: " + key));
        }
        return PortmapResponse.intReply(out, xid, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized XDR dump(int xid, XDR in, XDR out) {
        PortmapMapping[] pmapList = null;
        RpcProgramPortmap rpcProgramPortmap = this;
        synchronized (rpcProgramPortmap) {
            pmapList = new PortmapMapping[this.map.values().size()];
            this.map.values().toArray(pmapList);
        }
        return PortmapResponse.pmapList(out, xid, pmapList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(PortmapMapping mapping) {
        String key = PortmapMapping.key(mapping);
        RpcProgramPortmap rpcProgramPortmap = this;
        synchronized (rpcProgramPortmap) {
            this.map.put(key, mapping);
        }
    }

    @Override
    public void handleInternal(ChannelHandlerContext ctx, RpcInfo info) {
        RpcCall rpcCall = (RpcCall)info.header();
        PortmapInterface.Procedure portmapProc = PortmapInterface.Procedure.fromValue(rpcCall.getProcedure());
        int xid = rpcCall.getXid();
        byte[] data = new byte[info.data().readableBytes()];
        info.data().readBytes(data);
        XDR in = new XDR(data);
        XDR out = new XDR();
        if (portmapProc == PortmapInterface.Procedure.PMAPPROC_NULL) {
            out = this.nullOp(xid, in, out);
        } else if (portmapProc == PortmapInterface.Procedure.PMAPPROC_SET) {
            out = this.set(xid, in, out);
        } else if (portmapProc == PortmapInterface.Procedure.PMAPPROC_UNSET) {
            out = this.unset(xid, in, out);
        } else if (portmapProc == PortmapInterface.Procedure.PMAPPROC_DUMP) {
            out = this.dump(xid, in, out);
        } else if (portmapProc == PortmapInterface.Procedure.PMAPPROC_GETPORT) {
            out = this.getport(xid, in, out);
        } else if (portmapProc == PortmapInterface.Procedure.PMAPPROC_GETVERSADDR) {
            out = this.getport(xid, in, out);
        } else {
            LOG.info((Object)("PortmapHandler unknown rpc procedure=" + (Object)((Object)portmapProc)));
            RpcAcceptedReply reply = RpcAcceptedReply.getInstance(xid, RpcAcceptedReply.AcceptState.PROC_UNAVAIL, new VerifierNone());
            reply.write(out);
        }
        ChannelBuffer buf = ChannelBuffers.wrappedBuffer((ByteBuffer)out.asReadOnlyWrap().buffer());
        RpcResponse rsp = new RpcResponse(buf, info.remoteAddress());
        RpcUtil.sendRpcResponse(ctx, rsp);
    }

    @Override
    protected boolean isIdempotent(RpcCall call) {
        return false;
    }
}

