/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.FileSystemRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptStoredEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRMStateStore {
    public static final Log LOG = LogFactory.getLog(TestRMStateStore.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFSRMStateStore() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            TestFSRMStateStoreTester fsTester = new TestFSRMStateStoreTester(cluster);
            this.testRMAppStateStore(fsTester);
            this.testRMDTSecretManagerStateStore(fsTester);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitNotify(TestDispatcher dispatcher) {
        long startTime = System.currentTimeMillis();
        while (!dispatcher.notified) {
            TestDispatcher testDispatcher = dispatcher;
            synchronized (testDispatcher) {
                try {
                    dispatcher.wait(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (System.currentTimeMillis() - startTime <= 60000L) continue;
            Assert.fail((String)"Timed out attempt store notification");
        }
        dispatcher.notified = false;
    }

    void storeApp(RMStateStore store, ApplicationId appId, long time) throws Exception {
        ApplicationSubmissionContextPBImpl context = new ApplicationSubmissionContextPBImpl();
        context.setApplicationId(appId);
        RMApp mockApp = (RMApp)Mockito.mock(RMApp.class);
        Mockito.when((Object)mockApp.getApplicationId()).thenReturn((Object)appId);
        Mockito.when((Object)mockApp.getSubmitTime()).thenReturn((Object)time);
        Mockito.when((Object)mockApp.getApplicationSubmissionContext()).thenReturn((Object)context);
        Mockito.when((Object)mockApp.getUser()).thenReturn((Object)"test");
        store.storeApplication(mockApp);
    }

    ContainerId storeAttempt(RMStateStore store, ApplicationAttemptId attemptId, String containerIdStr, Token<AMRMTokenIdentifier> appToken, SecretKey clientTokenMasterKey, TestDispatcher dispatcher) throws Exception {
        ContainerPBImpl container = new ContainerPBImpl();
        container.setId(ConverterUtils.toContainerId((String)containerIdStr));
        RMAppAttempt mockAttempt = (RMAppAttempt)Mockito.mock(RMAppAttempt.class);
        Mockito.when((Object)mockAttempt.getAppAttemptId()).thenReturn((Object)attemptId);
        Mockito.when((Object)mockAttempt.getMasterContainer()).thenReturn((Object)container);
        Mockito.when((Object)mockAttempt.getAMRMToken()).thenReturn(appToken);
        Mockito.when((Object)mockAttempt.getClientTokenMasterKey()).thenReturn((Object)clientTokenMasterKey);
        dispatcher.attemptId = attemptId;
        dispatcher.storedException = null;
        store.storeApplicationAttempt(mockAttempt);
        this.waitNotify(dispatcher);
        return container.getId();
    }

    void testRMAppStateStore(RMStateStoreHelper stateStoreHelper) throws Exception {
        long submitTime = System.currentTimeMillis();
        YarnConfiguration conf = new YarnConfiguration();
        RMStateStore store = stateStoreHelper.getRMStateStore();
        TestDispatcher dispatcher = new TestDispatcher();
        store.setRMDispatcher((Dispatcher)dispatcher);
        AMRMTokenSecretManager appTokenMgr = new AMRMTokenSecretManager((Configuration)conf);
        ClientToAMTokenSecretManagerInRM clientToAMTokenMgr = new ClientToAMTokenSecretManagerInRM();
        ApplicationAttemptId attemptId1 = ConverterUtils.toApplicationAttemptId((String)"appattempt_1352994193343_0001_000001");
        ApplicationId appId1 = attemptId1.getApplicationId();
        this.storeApp(store, appId1, submitTime);
        Token<AMRMTokenIdentifier> appAttemptToken1 = this.generateAMRMToken(attemptId1, appTokenMgr);
        HashSet<Token<AMRMTokenIdentifier>> attemptTokenSet1 = new HashSet<Token<AMRMTokenIdentifier>>();
        attemptTokenSet1.add(appAttemptToken1);
        SecretKey clientTokenKey1 = clientToAMTokenMgr.createMasterKey(attemptId1);
        ContainerId containerId1 = this.storeAttempt(store, attemptId1, "container_1352994193343_0001_01_000001", appAttemptToken1, clientTokenKey1, dispatcher);
        String appAttemptIdStr2 = "appattempt_1352994193343_0001_000002";
        ApplicationAttemptId attemptId2 = ConverterUtils.toApplicationAttemptId((String)appAttemptIdStr2);
        Token<AMRMTokenIdentifier> appAttemptToken2 = this.generateAMRMToken(attemptId2, appTokenMgr);
        HashSet<Token<AMRMTokenIdentifier>> attemptTokenSet2 = new HashSet<Token<AMRMTokenIdentifier>>();
        attemptTokenSet2.add(appAttemptToken2);
        SecretKey clientTokenKey2 = clientToAMTokenMgr.createMasterKey(attemptId2);
        ContainerId containerId2 = this.storeAttempt(store, attemptId2, "container_1352994193343_0001_02_000001", appAttemptToken2, clientTokenKey2, dispatcher);
        ApplicationAttemptId attemptIdRemoved = ConverterUtils.toApplicationAttemptId((String)"appattempt_1352994193343_0002_000001");
        ApplicationId appIdRemoved = attemptIdRemoved.getApplicationId();
        this.storeApp(store, appIdRemoved, submitTime);
        this.storeAttempt(store, attemptIdRemoved, "container_1352994193343_0002_01_000001", null, null, dispatcher);
        RMApp mockRemovedApp = (RMApp)Mockito.mock(RMApp.class);
        HashMap<ApplicationAttemptId, RMAppAttempt> attempts = new HashMap<ApplicationAttemptId, RMAppAttempt>();
        ApplicationSubmissionContextPBImpl context = new ApplicationSubmissionContextPBImpl();
        context.setApplicationId(appIdRemoved);
        Mockito.when((Object)mockRemovedApp.getSubmitTime()).thenReturn((Object)submitTime);
        Mockito.when((Object)mockRemovedApp.getApplicationSubmissionContext()).thenReturn((Object)context);
        Mockito.when((Object)mockRemovedApp.getAppAttempts()).thenReturn(attempts);
        RMAppAttempt mockRemovedAttempt = (RMAppAttempt)Mockito.mock(RMAppAttempt.class);
        Mockito.when((Object)mockRemovedAttempt.getAppAttemptId()).thenReturn((Object)attemptIdRemoved);
        attempts.put(attemptIdRemoved, mockRemovedAttempt);
        store.removeApplication(mockRemovedApp);
        Thread.sleep(1000L);
        store.close();
        store = stateStoreHelper.getRMStateStore();
        RMStateStore.RMState state = store.loadState();
        Map rmAppState = state.getApplicationState();
        RMStateStore.ApplicationState appState = (RMStateStore.ApplicationState)rmAppState.get(appId1);
        Assert.assertNotNull((Object)appState);
        Assert.assertEquals((long)submitTime, (long)appState.getSubmitTime());
        Assert.assertEquals((Object)appId1, (Object)appState.getApplicationSubmissionContext().getApplicationId());
        RMStateStore.ApplicationAttemptState attemptState = appState.getAttempt(attemptId1);
        Assert.assertNotNull((Object)attemptState);
        Assert.assertEquals((Object)attemptId1, (Object)attemptState.getAttemptId());
        Assert.assertEquals((Object)containerId1, (Object)attemptState.getMasterContainer().getId());
        HashSet savedTokens = new HashSet();
        savedTokens.addAll(attemptState.getAppAttemptCredentials().getAllTokens());
        Assert.assertEquals(attemptTokenSet1, savedTokens);
        Assert.assertArrayEquals((byte[])clientTokenKey1.getEncoded(), (byte[])attemptState.getAppAttemptCredentials().getSecretKey(RMStateStore.AM_CLIENT_TOKEN_MASTER_KEY_NAME));
        attemptState = appState.getAttempt(attemptId2);
        Assert.assertNotNull((Object)attemptState);
        Assert.assertEquals((Object)attemptId2, (Object)attemptState.getAttemptId());
        Assert.assertEquals((Object)containerId2, (Object)attemptState.getMasterContainer().getId());
        savedTokens.clear();
        savedTokens.addAll(attemptState.getAppAttemptCredentials().getAllTokens());
        Assert.assertEquals(attemptTokenSet2, savedTokens);
        Assert.assertArrayEquals((byte[])clientTokenKey2.getEncoded(), (byte[])attemptState.getAppAttemptCredentials().getSecretKey(RMStateStore.AM_CLIENT_TOKEN_MASTER_KEY_NAME));
        Assert.assertTrue((boolean)stateStoreHelper.isFinalStateValid());
        store.close();
    }

    public void testRMDTSecretManagerStateStore(RMStateStoreHelper stateStoreHelper) throws Exception {
        RMStateStore store = stateStoreHelper.getRMStateStore();
        TestDispatcher dispatcher = new TestDispatcher();
        store.setRMDispatcher((Dispatcher)dispatcher);
        RMDelegationTokenIdentifier dtId1 = new RMDelegationTokenIdentifier(new Text("owner1"), new Text("renewer1"), new Text("realuser1"));
        Long renewDate1 = new Long(System.currentTimeMillis());
        int sequenceNumber = 1111;
        store.storeRMDelegationTokenAndSequenceNumber(dtId1, renewDate1, sequenceNumber);
        HashMap<RMDelegationTokenIdentifier, Long> token1 = new HashMap<RMDelegationTokenIdentifier, Long>();
        token1.put(dtId1, renewDate1);
        DelegationKey key = new DelegationKey(1234, 4321L, "keyBytes".getBytes());
        HashSet<DelegationKey> keySet = new HashSet<DelegationKey>();
        keySet.add(key);
        store.storeRMDTMasterKey(key);
        RMStateStore.RMDTSecretManagerState secretManagerState = store.loadState().getRMDTSecretManagerState();
        junit.framework.Assert.assertEquals(token1, (Object)secretManagerState.getTokenState());
        junit.framework.Assert.assertEquals(keySet, (Object)secretManagerState.getMasterKeyState());
        junit.framework.Assert.assertEquals((int)sequenceNumber, (int)secretManagerState.getDTSequenceNumber());
    }

    private Token<AMRMTokenIdentifier> generateAMRMToken(ApplicationAttemptId attemptId, AMRMTokenSecretManager appTokenMgr) {
        AMRMTokenIdentifier appTokenId = new AMRMTokenIdentifier(attemptId);
        Token appToken = new Token((TokenIdentifier)appTokenId, (SecretManager)appTokenMgr);
        appToken.setService(new Text("appToken service"));
        return appToken;
    }

    class TestFSRMStateStoreTester
    implements RMStateStoreHelper {
        Path workingDirPathURI;
        FileSystemRMStateStore store;
        MiniDFSCluster cluster;

        public TestFSRMStateStoreTester(MiniDFSCluster cluster) throws Exception {
            Path workingDirPath = new Path("/Test");
            this.cluster = cluster;
            DistributedFileSystem fs = cluster.getFileSystem();
            fs.mkdirs(workingDirPath);
            Path clusterURI = new Path(cluster.getURI());
            this.workingDirPathURI = new Path(clusterURI, workingDirPath);
            fs.close();
        }

        @Override
        public RMStateStore getRMStateStore() throws Exception {
            YarnConfiguration conf = new YarnConfiguration();
            conf.set("yarn.resourcemanager.fs.state-store.uri", this.workingDirPathURI.toString());
            this.store = new TestFileSystemRMStore((Configuration)conf);
            return this.store;
        }

        @Override
        public boolean isFinalStateValid() throws Exception {
            DistributedFileSystem fs = this.cluster.getFileSystem();
            FileStatus[] files = fs.listStatus(this.workingDirPathURI);
            return files.length == 1;
        }

        class TestFileSystemRMStore
        extends FileSystemRMStateStore {
            TestFileSystemRMStore(Configuration conf) throws Exception {
                this.init(conf);
                junit.framework.Assert.assertNull((Object)this.fs);
                Assert.assertTrue((boolean)TestFSRMStateStoreTester.this.workingDirPathURI.equals((Object)this.fsWorkingPath));
                this.start();
                junit.framework.Assert.assertNotNull((Object)this.fs);
            }
        }
    }

    static interface RMStateStoreHelper {
        public RMStateStore getRMStateStore() throws Exception;

        public boolean isFinalStateValid() throws Exception;
    }

    class TestDispatcher
    implements Dispatcher,
    EventHandler<RMAppAttemptStoredEvent> {
        ApplicationAttemptId attemptId;
        Exception storedException;
        boolean notified = false;

        TestDispatcher() {
        }

        public void register(Class<? extends Enum> eventType, EventHandler handler) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(RMAppAttemptStoredEvent event) {
            Assert.assertEquals((Object)this.attemptId, (Object)event.getApplicationAttemptId());
            Assert.assertEquals((Object)this.storedException, (Object)event.getStoredException());
            this.notified = true;
            TestDispatcher testDispatcher = this;
            synchronized (testDispatcher) {
                this.notifyAll();
            }
        }

        public EventHandler getEventHandler() {
            return this;
        }
    }
}

