/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.test.MockitoMaker;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestQueueMetrics {
    static final int GB = 1024;
    private static final Configuration conf = new Configuration();
    private MetricsSystem ms;

    @Before
    public void setUp() {
        this.ms = new MetricsSystemImpl();
        QueueMetrics.clearQueueMetrics();
    }

    @Test
    public void testDefaultSingleQueueMetrics() {
        String queueName = "single";
        String user = "alice";
        QueueMetrics metrics = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)queueName, null, (boolean)false, (Configuration)conf);
        MetricsSource queueSource = TestQueueMetrics.queueSource(this.ms, queueName);
        AppSchedulingInfo app = TestQueueMetrics.mockApp(user);
        metrics.submitApp(user, 1);
        MetricsSource userSource = TestQueueMetrics.userSource(this.ms, queueName, user);
        TestQueueMetrics.checkApps(queueSource, 1, 1, 0, 0, 0, 0, true);
        metrics.setAvailableResourcesToQueue(Resources.createResource((int)102400, (int)100));
        metrics.incrPendingResources(user, 5, Resources.createResource((int)15360, (int)15));
        TestQueueMetrics.checkResources(queueSource, 0, 0, 0, 0L, 0L, 102400, 100, 15360, 15, 5, 0, 0, 0);
        metrics.incrAppsRunning(app, user);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 1, 0, 0, 0, true);
        metrics.allocateResources(user, 3, Resources.createResource((int)2048, (int)2));
        TestQueueMetrics.checkResources(queueSource, 6144, 6, 3, 3L, 0L, 102400, 100, 9216, 9, 2, 0, 0, 0);
        metrics.releaseResources(user, 1, Resources.createResource((int)2048, (int)2));
        TestQueueMetrics.checkResources(queueSource, 4096, 4, 2, 3L, 1L, 102400, 100, 9216, 9, 2, 0, 0, 0);
        metrics.finishApp(app, RMAppAttemptState.FINISHED);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 0, 1, 0, 0, true);
        Assert.assertNull((Object)userSource);
    }

    @Test
    public void testQueueAppMetricsForMultipleFailures() {
        String queueName = "single";
        String user = "alice";
        QueueMetrics metrics = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)queueName, null, (boolean)false, (Configuration)new Configuration());
        MetricsSource queueSource = TestQueueMetrics.queueSource(this.ms, queueName);
        AppSchedulingInfo app = TestQueueMetrics.mockApp(user);
        metrics.submitApp(user, 1);
        MetricsSource userSource = TestQueueMetrics.userSource(this.ms, queueName, user);
        TestQueueMetrics.checkApps(queueSource, 1, 1, 0, 0, 0, 0, true);
        metrics.incrAppsRunning(app, user);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 1, 0, 0, 0, true);
        metrics.finishApp(app, RMAppAttemptState.FAILED);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 0, 0, 1, 0, true);
        metrics.submitApp(user, 2);
        TestQueueMetrics.checkApps(queueSource, 1, 1, 0, 0, 0, 0, true);
        metrics.incrAppsRunning(app, user);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 1, 0, 0, 0, true);
        metrics.finishApp(app, RMAppAttemptState.FAILED);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 0, 0, 1, 0, true);
        metrics.submitApp(user, 3);
        TestQueueMetrics.checkApps(queueSource, 1, 1, 0, 0, 0, 0, true);
        metrics.incrAppsRunning(app, user);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 1, 0, 0, 0, true);
        metrics.finishApp(app, RMAppAttemptState.FINISHED);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 0, 1, 0, 0, true);
        Assert.assertNull((Object)userSource);
    }

    @Test
    public void testSingleQueueWithUserMetrics() {
        String queueName = "single2";
        String user = "dodo";
        QueueMetrics metrics = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)queueName, null, (boolean)true, (Configuration)conf);
        MetricsSource queueSource = TestQueueMetrics.queueSource(this.ms, queueName);
        AppSchedulingInfo app = TestQueueMetrics.mockApp(user);
        metrics.submitApp(user, 1);
        MetricsSource userSource = TestQueueMetrics.userSource(this.ms, queueName, user);
        TestQueueMetrics.checkApps(queueSource, 1, 1, 0, 0, 0, 0, true);
        TestQueueMetrics.checkApps(userSource, 1, 1, 0, 0, 0, 0, true);
        metrics.setAvailableResourcesToQueue(Resources.createResource((int)102400, (int)100));
        metrics.setAvailableResourcesToUser(user, Resources.createResource((int)10240, (int)10));
        metrics.incrPendingResources(user, 5, Resources.createResource((int)15360, (int)15));
        TestQueueMetrics.checkResources(queueSource, 0, 0, 0, 0L, 0L, 102400, 100, 15360, 15, 5, 0, 0, 0);
        TestQueueMetrics.checkResources(userSource, 0, 0, 0, 0L, 0L, 10240, 10, 15360, 15, 5, 0, 0, 0);
        metrics.incrAppsRunning(app, user);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 1, 0, 0, 0, true);
        TestQueueMetrics.checkApps(userSource, 1, 0, 1, 0, 0, 0, true);
        metrics.allocateResources(user, 3, Resources.createResource((int)2048, (int)2));
        TestQueueMetrics.checkResources(queueSource, 6144, 6, 3, 3L, 0L, 102400, 100, 9216, 9, 2, 0, 0, 0);
        TestQueueMetrics.checkResources(userSource, 6144, 6, 3, 3L, 0L, 10240, 10, 9216, 9, 2, 0, 0, 0);
        metrics.releaseResources(user, 1, Resources.createResource((int)2048, (int)2));
        TestQueueMetrics.checkResources(queueSource, 4096, 4, 2, 3L, 1L, 102400, 100, 9216, 9, 2, 0, 0, 0);
        TestQueueMetrics.checkResources(userSource, 4096, 4, 2, 3L, 1L, 10240, 10, 9216, 9, 2, 0, 0, 0);
        metrics.finishApp(app, RMAppAttemptState.FINISHED);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 0, 1, 0, 0, true);
        TestQueueMetrics.checkApps(userSource, 1, 0, 0, 1, 0, 0, true);
    }

    @Test
    public void testTwoLevelWithUserMetrics() {
        String parentQueueName = "root";
        String leafQueueName = "root.leaf";
        String user = "alice";
        QueueMetrics parentMetrics = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)parentQueueName, null, (boolean)true, (Configuration)conf);
        Queue parentQueue = (Queue)MockitoMaker.make((Object)((Queue)MockitoMaker.stub(Queue.class).returning((Object)parentMetrics).from).getMetrics());
        QueueMetrics metrics = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)leafQueueName, (Queue)parentQueue, (boolean)true, (Configuration)conf);
        MetricsSource parentQueueSource = TestQueueMetrics.queueSource(this.ms, parentQueueName);
        MetricsSource queueSource = TestQueueMetrics.queueSource(this.ms, leafQueueName);
        AppSchedulingInfo app = TestQueueMetrics.mockApp(user);
        metrics.submitApp(user, 1);
        MetricsSource userSource = TestQueueMetrics.userSource(this.ms, leafQueueName, user);
        MetricsSource parentUserSource = TestQueueMetrics.userSource(this.ms, parentQueueName, user);
        TestQueueMetrics.checkApps(queueSource, 1, 1, 0, 0, 0, 0, true);
        TestQueueMetrics.checkApps(parentQueueSource, 1, 1, 0, 0, 0, 0, true);
        TestQueueMetrics.checkApps(userSource, 1, 1, 0, 0, 0, 0, true);
        TestQueueMetrics.checkApps(parentUserSource, 1, 1, 0, 0, 0, 0, true);
        parentMetrics.setAvailableResourcesToQueue(Resources.createResource((int)102400, (int)100));
        metrics.setAvailableResourcesToQueue(Resources.createResource((int)102400, (int)100));
        parentMetrics.setAvailableResourcesToUser(user, Resources.createResource((int)10240, (int)10));
        metrics.setAvailableResourcesToUser(user, Resources.createResource((int)10240, (int)10));
        metrics.incrPendingResources(user, 5, Resources.createResource((int)15360, (int)15));
        TestQueueMetrics.checkResources(queueSource, 0, 0, 0, 0L, 0L, 102400, 100, 15360, 15, 5, 0, 0, 0);
        TestQueueMetrics.checkResources(parentQueueSource, 0, 0, 0, 0L, 0L, 102400, 100, 15360, 15, 5, 0, 0, 0);
        TestQueueMetrics.checkResources(userSource, 0, 0, 0, 0L, 0L, 10240, 10, 15360, 15, 5, 0, 0, 0);
        TestQueueMetrics.checkResources(parentUserSource, 0, 0, 0, 0L, 0L, 10240, 10, 15360, 15, 5, 0, 0, 0);
        metrics.incrAppsRunning(app, user);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 1, 0, 0, 0, true);
        TestQueueMetrics.checkApps(userSource, 1, 0, 1, 0, 0, 0, true);
        metrics.allocateResources(user, 3, Resources.createResource((int)2048, (int)2));
        metrics.reserveResource(user, Resources.createResource((int)3072, (int)3));
        TestQueueMetrics.checkResources(queueSource, 6144, 6, 3, 3L, 0L, 102400, 100, 9216, 9, 2, 3072, 3, 1);
        TestQueueMetrics.checkResources(parentQueueSource, 6144, 6, 3, 3L, 0L, 102400, 100, 9216, 9, 2, 3072, 3, 1);
        TestQueueMetrics.checkResources(userSource, 6144, 6, 3, 3L, 0L, 10240, 10, 9216, 9, 2, 3072, 3, 1);
        TestQueueMetrics.checkResources(parentUserSource, 6144, 6, 3, 3L, 0L, 10240, 10, 9216, 9, 2, 3072, 3, 1);
        metrics.releaseResources(user, 1, Resources.createResource((int)2048, (int)2));
        metrics.unreserveResource(user, Resources.createResource((int)3072, (int)3));
        TestQueueMetrics.checkResources(queueSource, 4096, 4, 2, 3L, 1L, 102400, 100, 9216, 9, 2, 0, 0, 0);
        TestQueueMetrics.checkResources(parentQueueSource, 4096, 4, 2, 3L, 1L, 102400, 100, 9216, 9, 2, 0, 0, 0);
        TestQueueMetrics.checkResources(userSource, 4096, 4, 2, 3L, 1L, 10240, 10, 9216, 9, 2, 0, 0, 0);
        TestQueueMetrics.checkResources(parentUserSource, 4096, 4, 2, 3L, 1L, 10240, 10, 9216, 9, 2, 0, 0, 0);
        metrics.finishApp(app, RMAppAttemptState.FINISHED);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 0, 1, 0, 0, true);
        TestQueueMetrics.checkApps(parentQueueSource, 1, 0, 0, 1, 0, 0, true);
        TestQueueMetrics.checkApps(userSource, 1, 0, 0, 1, 0, 0, true);
        TestQueueMetrics.checkApps(parentUserSource, 1, 0, 0, 1, 0, 0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricsCache() {
        MetricsSystemImpl ms = new MetricsSystemImpl("cache");
        ms.start();
        try {
            String p1 = "root1";
            String leafQueueName = "root1.leaf";
            QueueMetrics p1Metrics = QueueMetrics.forQueue((MetricsSystem)ms, (String)p1, null, (boolean)true, (Configuration)conf);
            Queue parentQueue1 = (Queue)MockitoMaker.make((Object)((Queue)MockitoMaker.stub(Queue.class).returning((Object)p1Metrics).from).getMetrics());
            QueueMetrics metrics = QueueMetrics.forQueue((MetricsSystem)ms, (String)leafQueueName, (Queue)parentQueue1, (boolean)true, (Configuration)conf);
            Assert.assertNotNull((String)"QueueMetrics for A shoudn't be null", (Object)metrics);
            QueueMetrics alterMetrics = QueueMetrics.forQueue((MetricsSystem)ms, (String)leafQueueName, (Queue)parentQueue1, (boolean)true, (Configuration)conf);
            Assert.assertNotNull((String)"QueueMetrics for alterMetrics shoudn't be null", (Object)alterMetrics);
        }
        finally {
            ms.shutdown();
        }
    }

    @Test
    public void testMetricsInitializedOnRMInit() {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)conf);
        QueueMetrics metrics = rm.getResourceScheduler().getRootQueueMetrics();
        TestQueueMetrics.checkApps((MetricsSource)metrics, 0, 0, 0, 0, 0, 0, true);
        MetricsAsserts.assertGauge((String)"ReservedContainers", (int)0, (MetricsSource)metrics);
    }

    @Test
    public void testCollectAllMetrics() {
        String queueName = "single";
        QueueMetrics.forQueue((MetricsSystem)this.ms, (String)queueName, null, (boolean)false, (Configuration)conf);
        MetricsSource queueSource = TestQueueMetrics.queueSource(this.ms, queueName);
        TestQueueMetrics.checkApps(queueSource, 0, 0, 0, 0, 0, 0, true);
        try {
            TestQueueMetrics.checkApps(queueSource, 0, 0, 0, 0, 0, 0, false);
            Assert.fail();
        }
        catch (AssertionError e) {
            Assert.assertTrue((boolean)((Throwable)((Object)e)).getMessage().contains("Expected exactly one metric for name "));
        }
        TestQueueMetrics.checkApps(queueSource, 0, 0, 0, 0, 0, 0, true);
    }

    public static void checkApps(MetricsSource source, int submitted, int pending, int running, int completed, int failed, int killed, boolean all) {
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((MetricsSource)source, (boolean)all);
        MetricsAsserts.assertCounter((String)"AppsSubmitted", (int)submitted, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"AppsPending", (int)pending, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"AppsRunning", (int)running, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"AppsCompleted", (int)completed, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"AppsFailed", (int)failed, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"AppsKilled", (int)killed, (MetricsRecordBuilder)rb);
    }

    public static void checkResources(MetricsSource source, int allocatedMB, int allocatedCores, int allocCtnrs, long aggreAllocCtnrs, long aggreReleasedCtnrs, int availableMB, int availableCores, int pendingMB, int pendingCores, int pendingCtnrs, int reservedMB, int reservedCores, int reservedCtnrs) {
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((MetricsSource)source);
        MetricsAsserts.assertGauge((String)"AllocatedMB", (int)allocatedMB, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"AllocatedVCores", (int)allocatedCores, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"AllocatedContainers", (int)allocCtnrs, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"AggregateContainersAllocated", (long)aggreAllocCtnrs, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"AggregateContainersReleased", (long)aggreReleasedCtnrs, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"AvailableMB", (int)availableMB, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"AvailableVCores", (int)availableCores, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingMB", (int)pendingMB, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingVCores", (int)pendingCores, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingContainers", (int)pendingCtnrs, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"ReservedMB", (int)reservedMB, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"ReservedVCores", (int)reservedCores, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"ReservedContainers", (int)reservedCtnrs, (MetricsRecordBuilder)rb);
    }

    private static AppSchedulingInfo mockApp(String user) {
        AppSchedulingInfo app = (AppSchedulingInfo)Mockito.mock(AppSchedulingInfo.class);
        Mockito.when((Object)app.getUser()).thenReturn((Object)user);
        ApplicationId appId = BuilderUtils.newApplicationId((long)1L, (int)1);
        ApplicationAttemptId id = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)1);
        Mockito.when((Object)app.getApplicationAttemptId()).thenReturn((Object)id);
        return app;
    }

    public static MetricsSource queueSource(MetricsSystem ms, String queue) {
        MetricsSource s = ms.getSource(QueueMetrics.sourceName((String)queue).toString());
        return s;
    }

    public static MetricsSource userSource(MetricsSystem ms, String queue, String user) {
        MetricsSource s = ms.getSource(QueueMetrics.sourceName((String)queue).append(",user=").append(user).toString());
        return s;
    }
}

