/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.MockRMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestCapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.DominantResourceFairnessPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.FifoPolicy;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

public class TestFairScheduler {
    static final String TEST_DIR = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
    static final String ALLOC_FILE = new File(TEST_DIR, "test-queues").getAbsolutePath();
    private FairScheduler scheduler;
    private ResourceManager resourceManager;
    private static RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private int APP_ID = 1;
    private int ATTEMPT_ID = 1;

    @Before
    public void setUp() throws IOException {
        this.scheduler = new FairScheduler();
        Configuration conf = this.createConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 0);
        conf.setInt("yarn.scheduler.increment-allocation-mb", 1024);
        conf.setInt("yarn.scheduler.maximum-allocation-mb", 10240);
        conf.set("yarn.scheduler.fair.assignmultiple", "false");
        this.resourceManager = new ResourceManager();
        this.resourceManager.init(conf);
        ((AsyncDispatcher)this.resourceManager.getRMContext().getDispatcher()).start();
        this.resourceManager.getRMContext().getStateStore().start();
        this.scheduler.reinitialize(conf, this.resourceManager.getRMContext());
        this.resourceManager.getRMContainerTokenSecretManager().rollMasterKey();
    }

    @After
    public void tearDown() {
        this.scheduler = null;
        this.resourceManager = null;
        QueueMetrics.clearQueueMetrics();
        DefaultMetricsSystem.shutdown();
    }

    @Test(timeout=30000L)
    public void testConfValidation() throws Exception {
        FairScheduler scheduler = new FairScheduler();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 2048);
        conf.setInt("yarn.scheduler.maximum-allocation-mb", 1024);
        try {
            scheduler.reinitialize((Configuration)conf, null);
            Assert.fail((String)"Exception is expected because the min memory allocation is larger than the max memory allocation.");
        }
        catch (YarnRuntimeException e) {
            Assert.assertTrue((String)"The thrown exception is not the expected one.", (boolean)e.getMessage().startsWith("Invalid resource scheduler memory"));
        }
        conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-vcores", 2);
        conf.setInt("yarn.scheduler.maximum-allocation-vcores", 1);
        try {
            scheduler.reinitialize((Configuration)conf, null);
            Assert.fail((String)"Exception is expected because the min vcores allocation is larger than the max vcores allocation.");
        }
        catch (YarnRuntimeException e) {
            Assert.assertTrue((String)"The thrown exception is not the expected one.", (boolean)e.getMessage().startsWith("Invalid resource scheduler vcores"));
        }
    }

    private Configuration createConfiguration() {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FairScheduler.class, ResourceScheduler.class);
        return conf;
    }

    private ApplicationAttemptId createAppAttemptId(int appId, int attemptId) {
        ApplicationId appIdImpl = ApplicationId.newInstance((long)0L, (int)appId);
        ApplicationAttemptId attId = ApplicationAttemptId.newInstance((ApplicationId)appIdImpl, (int)attemptId);
        return attId;
    }

    private ResourceRequest createResourceRequest(int memory, String host, int priority, int numContainers, boolean relaxLocality) {
        return this.createResourceRequest(memory, 1, host, priority, numContainers, relaxLocality);
    }

    private ResourceRequest createResourceRequest(int memory, int vcores, String host, int priority, int numContainers, boolean relaxLocality) {
        ResourceRequest request = (ResourceRequest)recordFactory.newRecordInstance(ResourceRequest.class);
        request.setCapability(BuilderUtils.newResource((int)memory, (int)vcores));
        request.setResourceName(host);
        request.setNumContainers(numContainers);
        Priority prio = (Priority)recordFactory.newRecordInstance(Priority.class);
        prio.setPriority(priority);
        request.setPriority(prio);
        request.setRelaxLocality(relaxLocality);
        return request;
    }

    private ApplicationAttemptId createSchedulingRequest(int memory, String queueId, String userId) {
        return this.createSchedulingRequest(memory, queueId, userId, 1);
    }

    private ApplicationAttemptId createSchedulingRequest(int memory, int vcores, String queueId, String userId) {
        return this.createSchedulingRequest(memory, vcores, queueId, userId, 1);
    }

    private ApplicationAttemptId createSchedulingRequest(int memory, String queueId, String userId, int numContainers) {
        return this.createSchedulingRequest(memory, queueId, userId, numContainers, 1);
    }

    private ApplicationAttemptId createSchedulingRequest(int memory, int vcores, String queueId, String userId, int numContainers) {
        return this.createSchedulingRequest(memory, vcores, queueId, userId, numContainers, 1);
    }

    private ApplicationAttemptId createSchedulingRequest(int memory, String queueId, String userId, int numContainers, int priority) {
        return this.createSchedulingRequest(memory, 1, queueId, userId, numContainers, priority);
    }

    private ApplicationAttemptId createSchedulingRequest(int memory, int vcores, String queueId, String userId, int numContainers, int priority) {
        ApplicationAttemptId id = this.createAppAttemptId(this.APP_ID++, this.ATTEMPT_ID++);
        this.scheduler.addApplication(id, queueId, userId);
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ResourceRequest request = this.createResourceRequest(memory, vcores, "*", priority, numContainers, true);
        ask.add(request);
        this.scheduler.allocate(id, ask, new ArrayList(), null, null);
        return id;
    }

    private void createSchedulingRequestExistingApplication(int memory, int priority, ApplicationAttemptId attId) {
        ResourceRequest request = this.createResourceRequest(memory, "*", priority, 1, true);
        this.createSchedulingRequestExistingApplication(request, attId);
    }

    private void createSchedulingRequestExistingApplication(int memory, int vcores, int priority, ApplicationAttemptId attId) {
        ResourceRequest request = this.createResourceRequest(memory, vcores, "*", priority, 1, true);
        this.createSchedulingRequestExistingApplication(request, attId);
    }

    private void createSchedulingRequestExistingApplication(ResourceRequest request, ApplicationAttemptId attId) {
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ask.add(request);
        this.scheduler.allocate(attId, ask, new ArrayList(), null, null);
    }

    @Test(timeout=2000L)
    public void testLoadConfigurationOnInitialize() throws IOException {
        Configuration conf = this.createConfiguration();
        conf.setBoolean("yarn.scheduler.fair.assignmultiple", true);
        conf.setInt("yarn.scheduler.fair.max.assign", 3);
        conf.setBoolean("yarn.scheduler.fair.sizebasedweight", true);
        conf.setFloat("yarn.scheduler.fair.locality.threshold.node", 0.5f);
        conf.setFloat("yarn.scheduler.fair.locality.threshold.rack", 0.7f);
        conf.setInt("yarn.scheduler.maximum-allocation-mb", 1024);
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 512);
        conf.setInt("yarn.scheduler.increment-allocation-mb", 128);
        this.scheduler.reinitialize(conf, this.resourceManager.getRMContext());
        junit.framework.Assert.assertEquals((boolean)true, (boolean)this.scheduler.assignMultiple);
        junit.framework.Assert.assertEquals((int)3, (int)this.scheduler.maxAssign);
        junit.framework.Assert.assertEquals((boolean)true, (boolean)this.scheduler.sizeBasedWeight);
        junit.framework.Assert.assertEquals((double)0.5, (double)this.scheduler.nodeLocalityThreshold, (double)0.01);
        junit.framework.Assert.assertEquals((double)0.7, (double)this.scheduler.rackLocalityThreshold, (double)0.01);
        junit.framework.Assert.assertEquals((int)1024, (int)this.scheduler.getMaximumResourceCapability().getMemory());
        junit.framework.Assert.assertEquals((int)512, (int)this.scheduler.getMinimumResourceCapability().getMemory());
        junit.framework.Assert.assertEquals((int)128, (int)this.scheduler.getIncrementResourceCapability().getMemory());
    }

    @Test
    public void testNonMinZeroResourcesSettings() throws IOException {
        FairScheduler fs = new FairScheduler();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 256);
        conf.setInt("yarn.scheduler.minimum-allocation-vcores", 1);
        conf.setInt("yarn.scheduler.increment-allocation-mb", 512);
        conf.setInt("yarn.scheduler.increment-allocation-vcores", 2);
        fs.reinitialize((Configuration)conf, null);
        junit.framework.Assert.assertEquals((int)256, (int)fs.getMinimumResourceCapability().getMemory());
        junit.framework.Assert.assertEquals((int)1, (int)fs.getMinimumResourceCapability().getVirtualCores());
        junit.framework.Assert.assertEquals((int)512, (int)fs.getIncrementResourceCapability().getMemory());
        junit.framework.Assert.assertEquals((int)2, (int)fs.getIncrementResourceCapability().getVirtualCores());
    }

    @Test
    public void testMinZeroResourcesSettings() throws IOException {
        FairScheduler fs = new FairScheduler();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 0);
        conf.setInt("yarn.scheduler.minimum-allocation-vcores", 0);
        conf.setInt("yarn.scheduler.increment-allocation-mb", 512);
        conf.setInt("yarn.scheduler.increment-allocation-vcores", 2);
        fs.reinitialize((Configuration)conf, null);
        junit.framework.Assert.assertEquals((int)0, (int)fs.getMinimumResourceCapability().getMemory());
        junit.framework.Assert.assertEquals((int)0, (int)fs.getMinimumResourceCapability().getVirtualCores());
        junit.framework.Assert.assertEquals((int)512, (int)fs.getIncrementResourceCapability().getMemory());
        junit.framework.Assert.assertEquals((int)2, (int)fs.getIncrementResourceCapability().getVirtualCores());
    }

    @Test
    public void testAggregateCapacityTracking() throws Exception {
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getClusterCapacity().getMemory());
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)512), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        Assert.assertEquals((long)1536L, (long)this.scheduler.getClusterCapacity().getMemory());
        NodeRemovedSchedulerEvent nodeEvent3 = new NodeRemovedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent3);
        Assert.assertEquals((long)512L, (long)this.scheduler.getClusterCapacity().getMemory());
    }

    @Test
    public void testSimpleFairShareCalculation() {
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)10240), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(10240, "queue1", "user1");
        this.createSchedulingRequest(10240, "queue2", "user1");
        this.scheduler.update();
        Collection queues = this.scheduler.getQueueManager().getLeafQueues();
        Assert.assertEquals((long)3L, (long)queues.size());
        for (FSLeafQueue p : queues) {
            Assert.assertEquals((long)3414L, (long)p.getFairShare().getMemory());
            Assert.assertEquals((long)3414L, (long)p.getMetrics().getFairShareMB());
        }
    }

    @Test
    public void testSimpleHierarchicalFairShareCalculation() {
        int capacity = 240;
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)capacity), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(10240, "parent.queue2", "user1");
        this.createSchedulingRequest(10240, "parent.queue3", "user1");
        this.scheduler.update();
        QueueManager queueManager = this.scheduler.getQueueManager();
        Collection queues = queueManager.getLeafQueues();
        Assert.assertEquals((long)3L, (long)queues.size());
        FSLeafQueue queue1 = queueManager.getLeafQueue("default", true);
        FSLeafQueue queue2 = queueManager.getLeafQueue("parent.queue2", true);
        FSLeafQueue queue3 = queueManager.getLeafQueue("parent.queue3", true);
        Assert.assertEquals((long)(capacity / 2), (long)queue1.getFairShare().getMemory());
        Assert.assertEquals((long)(capacity / 2), (long)queue1.getMetrics().getFairShareMB());
        Assert.assertEquals((long)(capacity / 4), (long)queue2.getFairShare().getMemory());
        Assert.assertEquals((long)(capacity / 4), (long)queue2.getMetrics().getFairShareMB());
        Assert.assertEquals((long)(capacity / 4), (long)queue3.getFairShare().getMemory());
        Assert.assertEquals((long)(capacity / 4), (long)queue3.getMetrics().getFairShareMB());
    }

    @Test
    public void testHierarchicalQueuesSimilarParents() {
        QueueManager queueManager = this.scheduler.getQueueManager();
        FSLeafQueue leafQueue = queueManager.getLeafQueue("parent.child", true);
        junit.framework.Assert.assertEquals((int)2, (int)queueManager.getLeafQueues().size());
        junit.framework.Assert.assertNotNull((Object)leafQueue);
        junit.framework.Assert.assertEquals((String)"root.parent.child", (String)leafQueue.getName());
        FSLeafQueue leafQueue2 = queueManager.getLeafQueue("parent", true);
        junit.framework.Assert.assertNull((Object)leafQueue2);
        junit.framework.Assert.assertEquals((int)2, (int)queueManager.getLeafQueues().size());
        FSLeafQueue leafQueue3 = queueManager.getLeafQueue("parent.child.grandchild", true);
        junit.framework.Assert.assertNull((Object)leafQueue3);
        junit.framework.Assert.assertEquals((int)2, (int)queueManager.getLeafQueues().size());
        FSLeafQueue leafQueue4 = queueManager.getLeafQueue("parent.sister", true);
        junit.framework.Assert.assertNotNull((Object)leafQueue4);
        junit.framework.Assert.assertEquals((String)"root.parent.sister", (String)leafQueue4.getName());
        junit.framework.Assert.assertEquals((int)3, (int)queueManager.getLeafQueues().size());
    }

    @Test
    public void testSchedulerRootQueueMetrics() throws InterruptedException {
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024));
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        this.createSchedulingRequest(1024, "queue2", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.rootMetrics.getReservedMB());
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024));
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        NodeUpdateSchedulerEvent updateEvent2 = new NodeUpdateSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.scheduler.handle((SchedulerEvent)updateEvent2);
        Assert.assertEquals((long)1024L, (long)this.scheduler.rootMetrics.getReservedMB());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.rootMetrics.getReservedMB());
    }

    @Test(timeout=5000L)
    public void testSimpleContainerAllocation() {
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024, (int)4), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)512, (int)2), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.createSchedulingRequest(512, 2, "queue1", "user1", 2);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemory());
        NodeUpdateSchedulerEvent updateEvent2 = new NodeUpdateSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)updateEvent2);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemory());
        Assert.assertEquals((long)2L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getVirtualCores());
        FSQueueMetrics queue1Metrics = this.scheduler.getQueueManager().getQueue("queue1").getMetrics();
        Assert.assertEquals((long)1024L, (long)queue1Metrics.getAllocatedMB());
        Assert.assertEquals((long)2L, (long)queue1Metrics.getAllocatedVirtualCores());
        Assert.assertEquals((long)1024L, (long)this.scheduler.getRootQueueMetrics().getAllocatedMB());
        Assert.assertEquals((long)2L, (long)this.scheduler.getRootQueueMetrics().getAllocatedVirtualCores());
        Assert.assertEquals((long)512L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)4L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
    }

    @Test(timeout=5000L)
    public void testSimpleContainerReservation() throws InterruptedException {
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemory());
        ApplicationAttemptId attId = this.createSchedulingRequest(1024, "queue2", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getQueue("queue2").getResourceUsage().getMemory());
        Assert.assertEquals((long)1024L, (long)((FSSchedulerApp)this.scheduler.applications.get(attId)).getCurrentReservation().getMemory());
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        NodeUpdateSchedulerEvent updateEvent2 = new NodeUpdateSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.scheduler.handle((SchedulerEvent)updateEvent2);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getQueueManager().getQueue("queue2").getResourceUsage().getMemory());
        Assert.assertEquals((long)1024L, (long)((FSSchedulerApp)this.scheduler.applications.get(attId)).getCurrentReservation().getMemory());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)((FSSchedulerApp)this.scheduler.applications.get(attId)).getCurrentReservation().getMemory());
    }

    @Test
    public void testUserAsDefaultQueue() throws Exception {
        Configuration conf = this.createConfiguration();
        conf.set("yarn.scheduler.fair.user-as-default-queue", "true");
        this.scheduler.reinitialize(conf, this.resourceManager.getRMContext());
        RMContext rmContext = this.resourceManager.getRMContext();
        ConcurrentMap appsMap = rmContext.getRMApps();
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(1, 1);
        RMAppImpl rmApp = new RMAppImpl(appAttemptId.getApplicationId(), rmContext, conf, null, null, null, ApplicationSubmissionContext.newInstance(null, null, null, null, null, (boolean)false, (boolean)false, (int)0, null, null), null, null, 0L, null);
        appsMap.put(appAttemptId.getApplicationId(), rmApp);
        AppAddedSchedulerEvent appAddedEvent = new AppAddedSchedulerEvent(appAttemptId, "default", "user1");
        this.scheduler.handle((SchedulerEvent)appAddedEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueue("user1", true).getAppSchedulables().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getLeafQueue("default", true).getAppSchedulables().size());
        Assert.assertEquals((Object)"root.user1", (Object)rmApp.getQueue());
        conf.set("yarn.scheduler.fair.user-as-default-queue", "false");
        this.scheduler.reinitialize(conf, this.resourceManager.getRMContext());
        AppAddedSchedulerEvent appAddedEvent2 = new AppAddedSchedulerEvent(this.createAppAttemptId(2, 1), "default", "user2");
        this.scheduler.handle((SchedulerEvent)appAddedEvent2);
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueue("user1", true).getAppSchedulables().size());
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueue("default", true).getAppSchedulables().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getLeafQueue("user2", true).getAppSchedulables().size());
    }

    @Test
    public void testAssignToQueue() throws Exception {
        Configuration conf = this.createConfiguration();
        conf.set("yarn.scheduler.fair.user-as-default-queue", "true");
        this.scheduler.reinitialize(conf, this.resourceManager.getRMContext());
        MockRMApp rmApp1 = new MockRMApp(0, 0L, RMAppState.NEW);
        MockRMApp rmApp2 = new MockRMApp(1, 1L, RMAppState.NEW);
        FSLeafQueue queue1 = this.scheduler.assignToQueue((RMApp)rmApp1, "default", "asterix");
        FSLeafQueue queue2 = this.scheduler.assignToQueue((RMApp)rmApp2, "notdefault", "obelix");
        Assert.assertEquals((Object)rmApp1.getQueue(), (Object)queue1.getName());
        Assert.assertEquals((Object)"root.asterix", (Object)rmApp1.getQueue());
        Assert.assertEquals((Object)rmApp2.getQueue(), (Object)queue2.getName());
        Assert.assertEquals((Object)"root.notdefault", (Object)rmApp2.getQueue());
    }

    @Test
    public void testFairShareWithMinAlloc() throws Exception {
        Configuration conf = this.createConfiguration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.scheduler.reinitialize(conf, this.resourceManager.getRMContext());
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        QueueManager queueManager = this.scheduler.getQueueManager();
        queueManager.initialize();
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(2048, "queueA", "user1");
        this.createSchedulingRequest(2048, "queueB", "user1");
        this.scheduler.update();
        Collection queues = this.scheduler.getQueueManager().getLeafQueues();
        Assert.assertEquals((long)3L, (long)queues.size());
        for (FSLeafQueue p : queues) {
            if (p.getName().equals("root.queueA")) {
                Assert.assertEquals((long)1024L, (long)p.getFairShare().getMemory());
                continue;
            }
            if (!p.getName().equals("root.queueB")) continue;
            Assert.assertEquals((long)2048L, (long)p.getFairShare().getMemory());
        }
    }

    @Test
    public void testQueueDemandCalculation() throws Exception {
        ApplicationAttemptId id11 = this.createAppAttemptId(1, 1);
        this.scheduler.addApplication(id11, "root.queue1", "user1");
        ApplicationAttemptId id21 = this.createAppAttemptId(2, 1);
        this.scheduler.addApplication(id21, "root.queue2", "user1");
        ApplicationAttemptId id22 = this.createAppAttemptId(2, 2);
        this.scheduler.addApplication(id22, "root.queue2", "user1");
        int minReqSize = 1024;
        ArrayList<ResourceRequest> ask1 = new ArrayList<ResourceRequest>();
        ResourceRequest request1 = this.createResourceRequest(minReqSize * 2, "*", 1, 1, true);
        ask1.add(request1);
        this.scheduler.allocate(id11, ask1, new ArrayList(), null, null);
        ArrayList<ResourceRequest> ask2 = new ArrayList<ResourceRequest>();
        ResourceRequest request2 = this.createResourceRequest(2 * minReqSize, "foo", 1, 1, false);
        ResourceRequest request3 = this.createResourceRequest(minReqSize, "bar", 1, 2, false);
        ask2.add(request2);
        ask2.add(request3);
        this.scheduler.allocate(id21, ask2, new ArrayList(), null, null);
        ArrayList<ResourceRequest> ask3 = new ArrayList<ResourceRequest>();
        ResourceRequest request4 = this.createResourceRequest(2 * minReqSize, "*", 1, 1, true);
        ask3.add(request4);
        this.scheduler.allocate(id22, ask3, new ArrayList(), null, null);
        this.scheduler.update();
        Assert.assertEquals((long)(2 * minReqSize), (long)this.scheduler.getQueueManager().getQueue("root.queue1").getDemand().getMemory());
        Assert.assertEquals((long)(2 * minReqSize + 2 * minReqSize + 2 * minReqSize), (long)this.scheduler.getQueueManager().getQueue("root.queue2").getDemand().getMemory());
    }

    @Test
    public void testAppAdditionAndRemoval() throws Exception {
        AppAddedSchedulerEvent appAddedEvent1 = new AppAddedSchedulerEvent(this.createAppAttemptId(1, 1), "default", "user1");
        this.scheduler.handle((SchedulerEvent)appAddedEvent1);
        Assert.assertEquals((long)2L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueue("user1", true).getAppSchedulables().size());
        AppRemovedSchedulerEvent appRemovedEvent1 = new AppRemovedSchedulerEvent(this.createAppAttemptId(1, 1), RMAppAttemptState.FINISHED);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getLeafQueue("user1", true).getAppSchedulables().size());
    }

    @Test
    public void testAllocationFileParsing() throws Exception {
        Configuration conf = this.createConfiguration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.scheduler.reinitialize(conf, this.resourceManager.getRMContext());
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("<aclAdministerApps>alice,bob admins</aclAdministerApps>");
        out.println("</queue>");
        out.println("<queue name=\"queueC\">");
        out.println("<aclSubmitApps>alice,bob admins</aclSubmitApps>");
        out.println("</queue>");
        out.println("<queue name=\"queueD\">");
        out.println("<maxRunningApps>3</maxRunningApps>");
        out.println("</queue>");
        out.println("<queue name=\"queueE\">");
        out.println("<minSharePreemptionTimeout>60</minSharePreemptionTimeout>");
        out.println("</queue>");
        out.println("<queueMaxAppsDefault>15</queueMaxAppsDefault>");
        out.println("<userMaxAppsDefault>5</userMaxAppsDefault>");
        out.println("<user name=\"user1\">");
        out.println("<maxRunningApps>10</maxRunningApps>");
        out.println("</user>");
        out.println("<defaultMinSharePreemptionTimeout>120</defaultMinSharePreemptionTimeout>");
        out.println("<fairSharePreemptionTimeout>300</fairSharePreemptionTimeout>");
        out.println("</allocations>");
        out.close();
        QueueManager queueManager = this.scheduler.getQueueManager();
        queueManager.initialize();
        Assert.assertEquals((long)6L, (long)queueManager.getLeafQueues().size());
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueManager.getMinResources("root.default"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueManager.getMinResources("root.default"));
        Assert.assertEquals((Object)Resources.createResource((int)1024, (int)0), (Object)queueManager.getMinResources("root.queueA"));
        Assert.assertEquals((Object)Resources.createResource((int)2048, (int)0), (Object)queueManager.getMinResources("root.queueB"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueManager.getMinResources("root.queueC"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueManager.getMinResources("root.queueD"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueManager.getMinResources("root.queueE"));
        Assert.assertEquals((long)15L, (long)queueManager.getQueueMaxApps("root.default"));
        Assert.assertEquals((long)15L, (long)queueManager.getQueueMaxApps("root.queueA"));
        Assert.assertEquals((long)15L, (long)queueManager.getQueueMaxApps("root.queueB"));
        Assert.assertEquals((long)15L, (long)queueManager.getQueueMaxApps("root.queueC"));
        Assert.assertEquals((long)3L, (long)queueManager.getQueueMaxApps("root.queueD"));
        Assert.assertEquals((long)15L, (long)queueManager.getQueueMaxApps("root.queueE"));
        Assert.assertEquals((long)10L, (long)queueManager.getUserMaxApps("user1"));
        Assert.assertEquals((long)5L, (long)queueManager.getUserMaxApps("user2"));
        Map aclsA = queueManager.getQueueAcls("root.queueA");
        Assert.assertTrue((boolean)aclsA.containsKey(QueueACL.ADMINISTER_QUEUE));
        Assert.assertEquals((Object)"*", (Object)((AccessControlList)aclsA.get(QueueACL.ADMINISTER_QUEUE)).getAclString());
        Assert.assertTrue((boolean)aclsA.containsKey(QueueACL.SUBMIT_APPLICATIONS));
        Assert.assertEquals((Object)"*", (Object)((AccessControlList)aclsA.get(QueueACL.SUBMIT_APPLICATIONS)).getAclString());
        Map aclsB = queueManager.getQueueAcls("root.queueB");
        Assert.assertTrue((boolean)aclsB.containsKey(QueueACL.ADMINISTER_QUEUE));
        Assert.assertEquals((Object)"alice,bob admins", (Object)((AccessControlList)aclsB.get(QueueACL.ADMINISTER_QUEUE)).getAclString());
        Map aclsC = queueManager.getQueueAcls("root.queueC");
        Assert.assertTrue((boolean)aclsC.containsKey(QueueACL.SUBMIT_APPLICATIONS));
        Assert.assertEquals((Object)"alice,bob admins", (Object)((AccessControlList)aclsC.get(QueueACL.SUBMIT_APPLICATIONS)).getAclString());
        Assert.assertEquals((long)120000L, (long)queueManager.getMinSharePreemptionTimeout("root.default"));
        Assert.assertEquals((long)120000L, (long)queueManager.getMinSharePreemptionTimeout("root.queueA"));
        Assert.assertEquals((long)120000L, (long)queueManager.getMinSharePreemptionTimeout("root.queueB"));
        Assert.assertEquals((long)120000L, (long)queueManager.getMinSharePreemptionTimeout("root.queueC"));
        Assert.assertEquals((long)120000L, (long)queueManager.getMinSharePreemptionTimeout("root.queueD"));
        Assert.assertEquals((long)120000L, (long)queueManager.getMinSharePreemptionTimeout("root.queueA"));
        Assert.assertEquals((long)60000L, (long)queueManager.getMinSharePreemptionTimeout("root.queueE"));
        Assert.assertEquals((long)300000L, (long)queueManager.getFairSharePreemptionTimeout());
    }

    @Test
    public void testHierarchicalQueueAllocationFileParsing() throws IOException, SAXException, AllocationConfigurationException, ParserConfigurationException {
        Configuration conf = this.createConfiguration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.scheduler.reinitialize(conf, this.resourceManager.getRMContext());
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("<queue name=\"queueC\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueD\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        QueueManager queueManager = this.scheduler.getQueueManager();
        queueManager.initialize();
        Collection leafQueues = queueManager.getLeafQueues();
        junit.framework.Assert.assertEquals((int)4, (int)leafQueues.size());
        junit.framework.Assert.assertNotNull((Object)queueManager.getLeafQueue("queueA", true));
        junit.framework.Assert.assertNotNull((Object)queueManager.getLeafQueue("queueB.queueC", true));
        junit.framework.Assert.assertNotNull((Object)queueManager.getLeafQueue("queueB.queueD", true));
        junit.framework.Assert.assertNotNull((Object)queueManager.getLeafQueue("default", true));
        junit.framework.Assert.assertEquals((int)4, (int)leafQueues.size());
    }

    @Test
    public void testBackwardsCompatibleAllocationFileParsing() throws Exception {
        Configuration conf = this.createConfiguration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.scheduler.reinitialize(conf, this.resourceManager.getRMContext());
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<pool name=\"queueA\">");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</pool>");
        out.println("<pool name=\"queueB\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("<aclAdministerApps>alice,bob admins</aclAdministerApps>");
        out.println("</pool>");
        out.println("<pool name=\"queueC\">");
        out.println("<aclSubmitApps>alice,bob admins</aclSubmitApps>");
        out.println("</pool>");
        out.println("<pool name=\"queueD\">");
        out.println("<maxRunningApps>3</maxRunningApps>");
        out.println("</pool>");
        out.println("<pool name=\"queueE\">");
        out.println("<minSharePreemptionTimeout>60</minSharePreemptionTimeout>");
        out.println("</pool>");
        out.println("<queueMaxAppsDefault>15</queueMaxAppsDefault>");
        out.println("<userMaxAppsDefault>5</userMaxAppsDefault>");
        out.println("<user name=\"user1\">");
        out.println("<maxRunningApps>10</maxRunningApps>");
        out.println("</user>");
        out.println("<defaultMinSharePreemptionTimeout>120</defaultMinSharePreemptionTimeout>");
        out.println("<fairSharePreemptionTimeout>300</fairSharePreemptionTimeout>");
        out.println("</allocations>");
        out.close();
        QueueManager queueManager = this.scheduler.getQueueManager();
        queueManager.initialize();
        Assert.assertEquals((long)6L, (long)queueManager.getLeafQueues().size());
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueManager.getMinResources("root.default"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueManager.getMinResources("root.default"));
        Assert.assertEquals((Object)Resources.createResource((int)1024, (int)0), (Object)queueManager.getMinResources("root.queueA"));
        Assert.assertEquals((Object)Resources.createResource((int)2048, (int)0), (Object)queueManager.getMinResources("root.queueB"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueManager.getMinResources("root.queueC"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueManager.getMinResources("root.queueD"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueManager.getMinResources("root.queueE"));
        Assert.assertEquals((long)15L, (long)queueManager.getQueueMaxApps("root.default"));
        Assert.assertEquals((long)15L, (long)queueManager.getQueueMaxApps("root.queueA"));
        Assert.assertEquals((long)15L, (long)queueManager.getQueueMaxApps("root.queueB"));
        Assert.assertEquals((long)15L, (long)queueManager.getQueueMaxApps("root.queueC"));
        Assert.assertEquals((long)3L, (long)queueManager.getQueueMaxApps("root.queueD"));
        Assert.assertEquals((long)15L, (long)queueManager.getQueueMaxApps("root.queueE"));
        Assert.assertEquals((long)10L, (long)queueManager.getUserMaxApps("user1"));
        Assert.assertEquals((long)5L, (long)queueManager.getUserMaxApps("user2"));
        Map aclsA = queueManager.getQueueAcls("queueA");
        Assert.assertTrue((boolean)aclsA.containsKey(QueueACL.ADMINISTER_QUEUE));
        Assert.assertEquals((Object)"*", (Object)((AccessControlList)aclsA.get(QueueACL.ADMINISTER_QUEUE)).getAclString());
        Assert.assertTrue((boolean)aclsA.containsKey(QueueACL.SUBMIT_APPLICATIONS));
        Assert.assertEquals((Object)"*", (Object)((AccessControlList)aclsA.get(QueueACL.SUBMIT_APPLICATIONS)).getAclString());
        Map aclsB = queueManager.getQueueAcls("root.queueB");
        Assert.assertTrue((boolean)aclsB.containsKey(QueueACL.ADMINISTER_QUEUE));
        Assert.assertEquals((Object)"alice,bob admins", (Object)((AccessControlList)aclsB.get(QueueACL.ADMINISTER_QUEUE)).getAclString());
        Map aclsC = queueManager.getQueueAcls("root.queueC");
        Assert.assertTrue((boolean)aclsC.containsKey(QueueACL.SUBMIT_APPLICATIONS));
        Assert.assertEquals((Object)"alice,bob admins", (Object)((AccessControlList)aclsC.get(QueueACL.SUBMIT_APPLICATIONS)).getAclString());
        Assert.assertEquals((long)120000L, (long)queueManager.getMinSharePreemptionTimeout("root.default"));
        Assert.assertEquals((long)120000L, (long)queueManager.getMinSharePreemptionTimeout("root.queueA"));
        Assert.assertEquals((long)120000L, (long)queueManager.getMinSharePreemptionTimeout("root.queueB"));
        Assert.assertEquals((long)120000L, (long)queueManager.getMinSharePreemptionTimeout("root.queueC"));
        Assert.assertEquals((long)120000L, (long)queueManager.getMinSharePreemptionTimeout("root.queueD"));
        Assert.assertEquals((long)120000L, (long)queueManager.getMinSharePreemptionTimeout("root.queueA"));
        Assert.assertEquals((long)60000L, (long)queueManager.getMinSharePreemptionTimeout("root.queueE"));
        Assert.assertEquals((long)300000L, (long)queueManager.getFairSharePreemptionTimeout());
    }

    @Test(timeout=5000L)
    public void testIsStarvedForMinShare() throws Exception {
        Configuration conf = this.createConfiguration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.scheduler.reinitialize(conf, this.resourceManager.getRMContext());
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        QueueManager queueManager = this.scheduler.getQueueManager();
        queueManager.initialize();
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)4096, (int)4), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(3072, "queueA", "user1");
        this.scheduler.update();
        NodeUpdateSchedulerEvent nodeEvent2 = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.createSchedulingRequest(1024, "queueB", "user1");
        this.scheduler.update();
        Collection queues = this.scheduler.getQueueManager().getLeafQueues();
        Assert.assertEquals((long)3L, (long)queues.size());
        for (FSLeafQueue p : queues) {
            if (p.getName().equals("root.queueA")) {
                Assert.assertEquals((Object)false, (Object)this.scheduler.isStarvedForMinShare(p));
                continue;
            }
            if (!p.getName().equals("root.queueB")) continue;
            Assert.assertEquals((Object)true, (Object)this.scheduler.isStarvedForMinShare(p));
        }
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        for (FSLeafQueue p : queues) {
            if (!p.getName().equals("root.queueB")) continue;
            Assert.assertEquals((Object)false, (Object)this.scheduler.isStarvedForMinShare(p));
        }
    }

    @Test(timeout=5000L)
    public void testIsStarvedForFairShare() throws Exception {
        Configuration conf = this.createConfiguration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.scheduler.reinitialize(conf, this.resourceManager.getRMContext());
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<weight>.25</weight>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<weight>.75</weight>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        QueueManager queueManager = this.scheduler.getQueueManager();
        queueManager.initialize();
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)4096, (int)4), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(3072, "queueA", "user1");
        this.scheduler.update();
        NodeUpdateSchedulerEvent nodeEvent2 = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.createSchedulingRequest(1024, "queueB", "user1");
        this.scheduler.update();
        Collection queues = this.scheduler.getQueueManager().getLeafQueues();
        Assert.assertEquals((long)3L, (long)queues.size());
        for (FSLeafQueue p : queues) {
            if (p.getName().equals("root.queueA")) {
                Assert.assertEquals((Object)false, (Object)this.scheduler.isStarvedForFairShare(p));
                continue;
            }
            if (!p.getName().equals("root.queueB")) continue;
            Assert.assertEquals((Object)true, (Object)this.scheduler.isStarvedForFairShare(p));
        }
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        for (FSLeafQueue p : queues) {
            if (!p.getName().equals("root.queueB")) continue;
            Assert.assertEquals((Object)false, (Object)this.scheduler.isStarvedForFairShare(p));
        }
    }

    @Test(timeout=5000L)
    public void testChoiceOfPreemptedContainers() throws Exception {
        Configuration conf = this.createConfiguration();
        conf.setLong("yarn.scheduler.fair.preemptionInterval", 5000L);
        conf.setLong("yarn.scheduler.fair.waitTimeBeforeKill", 10000L);
        conf.set("yarn.scheduler.fair.allocation.file.allocation.file", ALLOC_FILE);
        this.scheduler.reinitialize(conf, this.resourceManager.getRMContext());
        MockClock clock = new MockClock();
        this.scheduler.setClock((Clock)clock);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<weight>.25</weight>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<weight>.25</weight>");
        out.println("</queue>");
        out.println("<queue name=\"queueC\">");
        out.println("<weight>.25</weight>");
        out.println("</queue>");
        out.println("<queue name=\"queueD\">");
        out.println("<weight>.25</weight>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        QueueManager queueManager = this.scheduler.getQueueManager();
        queueManager.initialize();
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)2048, (int)2), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)2048, (int)2), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        RMNode node3 = MockNodes.newNodeInfo(1, Resources.createResource((int)2048, (int)2), 3, "127.0.0.3");
        NodeAddedSchedulerEvent nodeEvent3 = new NodeAddedSchedulerEvent(node3);
        this.scheduler.handle((SchedulerEvent)nodeEvent3);
        ApplicationAttemptId app1 = this.createSchedulingRequest(1024, "queueA", "user1", 1, 1);
        ApplicationAttemptId app2 = this.createSchedulingRequest(1024, "queueA", "user1", 1, 2);
        ApplicationAttemptId app3 = this.createSchedulingRequest(1024, "queueA", "user1", 1, 3);
        ApplicationAttemptId app4 = this.createSchedulingRequest(1024, "queueB", "user1", 1, 1);
        ApplicationAttemptId app5 = this.createSchedulingRequest(1024, "queueB", "user1", 1, 2);
        ApplicationAttemptId app6 = this.createSchedulingRequest(1024, "queueB", "user1", 1, 3);
        this.scheduler.update();
        for (int i = 0; i < 2; ++i) {
            NodeUpdateSchedulerEvent nodeUpdate1 = new NodeUpdateSchedulerEvent(node1);
            this.scheduler.handle((SchedulerEvent)nodeUpdate1);
            NodeUpdateSchedulerEvent nodeUpdate2 = new NodeUpdateSchedulerEvent(node2);
            this.scheduler.handle((SchedulerEvent)nodeUpdate2);
            NodeUpdateSchedulerEvent nodeUpdate3 = new NodeUpdateSchedulerEvent(node3);
            this.scheduler.handle((SchedulerEvent)nodeUpdate3);
        }
        Assert.assertEquals((long)1L, (long)((FSSchedulerApp)this.scheduler.applications.get(app1)).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)((FSSchedulerApp)this.scheduler.applications.get(app2)).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)((FSSchedulerApp)this.scheduler.applications.get(app3)).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)((FSSchedulerApp)this.scheduler.applications.get(app4)).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)((FSSchedulerApp)this.scheduler.applications.get(app5)).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)((FSSchedulerApp)this.scheduler.applications.get(app6)).getLiveContainers().size());
        ApplicationAttemptId app7 = this.createSchedulingRequest(1024, "queueC", "user1", 1, 1);
        ApplicationAttemptId app8 = this.createSchedulingRequest(1024, "queueC", "user1", 1, 2);
        ApplicationAttemptId app9 = this.createSchedulingRequest(1024, "queueC", "user1", 1, 3);
        ApplicationAttemptId app10 = this.createSchedulingRequest(1024, "queueD", "user1", 1, 1);
        ApplicationAttemptId app11 = this.createSchedulingRequest(1024, "queueD", "user1", 1, 2);
        ApplicationAttemptId app12 = this.createSchedulingRequest(1024, "queueD", "user1", 1, 3);
        this.scheduler.update();
        this.scheduler.preemptResources(this.scheduler.getQueueManager().getLeafQueues(), Resources.createResource((int)2048));
        Assert.assertEquals((long)1L, (long)((FSSchedulerApp)this.scheduler.applications.get(app1)).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)((FSSchedulerApp)this.scheduler.applications.get(app2)).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)((FSSchedulerApp)this.scheduler.applications.get(app4)).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)((FSSchedulerApp)this.scheduler.applications.get(app5)).getLiveContainers().size());
        Assert.assertTrue((!Collections.disjoint(((FSSchedulerApp)this.scheduler.applications.get(app3)).getLiveContainers(), ((FSSchedulerApp)this.scheduler.applications.get(app3)).getPreemptionContainers()) ? 1 : 0) != 0);
        Assert.assertTrue((!Collections.disjoint(((FSSchedulerApp)this.scheduler.applications.get(app6)).getLiveContainers(), ((FSSchedulerApp)this.scheduler.applications.get(app6)).getPreemptionContainers()) ? 1 : 0) != 0);
        clock.tick(15);
        this.scheduler.preemptResources(this.scheduler.getQueueManager().getLeafQueues(), Resources.createResource((int)2048));
        Assert.assertEquals((long)0L, (long)((FSSchedulerApp)this.scheduler.applications.get(app6)).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)((FSSchedulerApp)this.scheduler.applications.get(app3)).getLiveContainers().size());
        this.scheduler.preemptResources(this.scheduler.getQueueManager().getLeafQueues(), Resources.createResource((int)2048));
        clock.tick(15);
        this.scheduler.preemptResources(this.scheduler.getQueueManager().getLeafQueues(), Resources.createResource((int)2048));
        Assert.assertEquals((long)1L, (long)((FSSchedulerApp)this.scheduler.applications.get(app1)).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)((FSSchedulerApp)this.scheduler.applications.get(app2)).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)((FSSchedulerApp)this.scheduler.applications.get(app3)).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)((FSSchedulerApp)this.scheduler.applications.get(app4)).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)((FSSchedulerApp)this.scheduler.applications.get(app5)).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)((FSSchedulerApp)this.scheduler.applications.get(app6)).getLiveContainers().size());
        this.scheduler.preemptResources(this.scheduler.getQueueManager().getLeafQueues(), Resources.createResource((int)2048));
        Assert.assertEquals((long)1L, (long)((FSSchedulerApp)this.scheduler.applications.get(app1)).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)((FSSchedulerApp)this.scheduler.applications.get(app2)).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)((FSSchedulerApp)this.scheduler.applications.get(app3)).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)((FSSchedulerApp)this.scheduler.applications.get(app4)).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)((FSSchedulerApp)this.scheduler.applications.get(app5)).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)((FSSchedulerApp)this.scheduler.applications.get(app6)).getLiveContainers().size());
    }

    @Test(timeout=5000L)
    public void testPreemptionDecision() throws Exception {
        Configuration conf = this.createConfiguration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        MockClock clock = new MockClock();
        this.scheduler.setClock((Clock)clock);
        this.scheduler.reinitialize(conf, this.resourceManager.getRMContext());
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueC\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueD\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.print("<defaultMinSharePreemptionTimeout>5</defaultMinSharePreemptionTimeout>");
        out.print("<fairSharePreemptionTimeout>10</fairSharePreemptionTimeout>");
        out.println("</allocations>");
        out.close();
        QueueManager queueManager = this.scheduler.getQueueManager();
        queueManager.initialize();
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)2048, (int)2), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)2048, (int)2), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        RMNode node3 = MockNodes.newNodeInfo(1, Resources.createResource((int)2048, (int)2), 3, "127.0.0.3");
        NodeAddedSchedulerEvent nodeEvent3 = new NodeAddedSchedulerEvent(node3);
        this.scheduler.handle((SchedulerEvent)nodeEvent3);
        ApplicationAttemptId app1 = this.createSchedulingRequest(1024, "queueA", "user1", 1, 1);
        ApplicationAttemptId app2 = this.createSchedulingRequest(1024, "queueA", "user1", 1, 2);
        ApplicationAttemptId app3 = this.createSchedulingRequest(1024, "queueA", "user1", 1, 3);
        ApplicationAttemptId app4 = this.createSchedulingRequest(1024, "queueB", "user1", 1, 1);
        ApplicationAttemptId app5 = this.createSchedulingRequest(1024, "queueB", "user1", 1, 2);
        ApplicationAttemptId app6 = this.createSchedulingRequest(1024, "queueB", "user1", 1, 3);
        this.scheduler.update();
        for (int i = 0; i < 2; ++i) {
            NodeUpdateSchedulerEvent nodeUpdate1 = new NodeUpdateSchedulerEvent(node1);
            this.scheduler.handle((SchedulerEvent)nodeUpdate1);
            NodeUpdateSchedulerEvent nodeUpdate2 = new NodeUpdateSchedulerEvent(node2);
            this.scheduler.handle((SchedulerEvent)nodeUpdate2);
            NodeUpdateSchedulerEvent nodeUpdate3 = new NodeUpdateSchedulerEvent(node3);
            this.scheduler.handle((SchedulerEvent)nodeUpdate3);
        }
        ApplicationAttemptId app7 = this.createSchedulingRequest(1024, "queueC", "user1", 1, 1);
        ApplicationAttemptId app8 = this.createSchedulingRequest(1024, "queueC", "user1", 1, 2);
        ApplicationAttemptId app9 = this.createSchedulingRequest(1024, "queueC", "user1", 1, 3);
        ApplicationAttemptId app10 = this.createSchedulingRequest(1024, "queueD", "user1", 1, 1);
        ApplicationAttemptId app11 = this.createSchedulingRequest(1024, "queueD", "user1", 1, 2);
        ApplicationAttemptId app12 = this.createSchedulingRequest(1024, "queueD", "user1", 1, 3);
        this.scheduler.update();
        FSLeafQueue schedC = this.scheduler.getQueueManager().getLeafQueue("queueC", true);
        FSLeafQueue schedD = this.scheduler.getQueueManager().getLeafQueue("queueD", true);
        Assert.assertTrue((boolean)Resources.equals((Resource)Resources.none(), (Resource)this.scheduler.resToPreempt(schedC, clock.getTime())));
        Assert.assertTrue((boolean)Resources.equals((Resource)Resources.none(), (Resource)this.scheduler.resToPreempt(schedD, clock.getTime())));
        clock.tick(6);
        Assert.assertEquals((long)1024L, (long)this.scheduler.resToPreempt(schedC, clock.getTime()).getMemory());
        Assert.assertEquals((long)1024L, (long)this.scheduler.resToPreempt(schedD, clock.getTime()).getMemory());
        this.scheduler.update();
        clock.tick(6);
        Assert.assertEquals((long)1536L, (long)this.scheduler.resToPreempt(schedC, clock.getTime()).getMemory());
        Assert.assertEquals((long)1536L, (long)this.scheduler.resToPreempt(schedD, clock.getTime()).getMemory());
    }

    @Test(timeout=5000L)
    public void testMultipleContainersWaitingForReservation() {
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue2", "user2", 1);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue3", "user3", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)((FSSchedulerApp)this.scheduler.applications.get(attId1)).getCurrentReservation().getMemory());
        Assert.assertEquals((long)0L, (long)((FSSchedulerApp)this.scheduler.applications.get(attId2)).getCurrentReservation().getMemory());
    }

    @Test(timeout=5000L)
    public void testUserMaxRunningApps() throws Exception {
        Configuration conf = this.createConfiguration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.scheduler.reinitialize(conf, this.resourceManager.getRMContext());
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<user name=\"user1\">");
        out.println("<maxRunningApps>1</maxRunningApps>");
        out.println("</user>");
        out.println("</allocations>");
        out.close();
        QueueManager queueManager = this.scheduler.getQueueManager();
        queueManager.initialize();
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)((FSSchedulerApp)this.scheduler.applications.get(attId1)).getLiveContainers().size());
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)((FSSchedulerApp)this.scheduler.applications.get(attId2)).getLiveContainers().size());
        this.createSchedulingRequestExistingApplication(1024, 1, attId1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2L, (long)((FSSchedulerApp)this.scheduler.applications.get(attId1)).getLiveContainers().size());
    }

    @Test(timeout=5000L)
    public void testReservationWhileMultiplePriorities() {
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024, (int)4), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId = this.createSchedulingRequest(1024, 4, "queue1", "user1", 1, 2);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        FSSchedulerApp app = (FSSchedulerApp)this.scheduler.applications.get(attId);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
        ContainerId containerId = ((RMContainer)((FSSchedulerApp)this.scheduler.applications.get(attId)).getLiveContainers().iterator().next()).getContainerId();
        this.createSchedulingRequestExistingApplication(1024, 4, 2, attId);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
        this.createSchedulingRequestExistingApplication(1024, 4, 1, attId);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
        for (RMContainer container : app.getReservedContainers()) {
            Assert.assertEquals((long)2L, (long)container.getReservedPriority().getPriority());
        }
        this.scheduler.allocate(attId, new ArrayList(), Arrays.asList(containerId), null, null);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)4L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Collection liveContainers = app.getLiveContainers();
        Assert.assertEquals((long)1L, (long)liveContainers.size());
        for (RMContainer liveContainer : liveContainers) {
            junit.framework.Assert.assertEquals((int)2, (int)liveContainer.getContainer().getPriority().getPriority());
        }
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
    }

    @Test
    public void testAclSubmitApplication() throws Exception {
        Configuration conf = this.createConfiguration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.scheduler.reinitialize(conf, this.resourceManager.getRMContext());
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queue1\">");
        out.println("<aclSubmitApps>norealuserhasthisname</aclSubmitApps>");
        out.println("<aclAdministerApps>norealuserhasthisname</aclAdministerApps>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        QueueManager queueManager = this.scheduler.getQueueManager();
        queueManager.initialize();
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "norealuserhasthisname", 1);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue1", "norealuserhasthisname2", 1);
        FSSchedulerApp app1 = (FSSchedulerApp)this.scheduler.applications.get(attId1);
        Assert.assertNotNull((String)"The application was not allowed", (Object)app1);
        FSSchedulerApp app2 = (FSSchedulerApp)this.scheduler.applications.get(attId2);
        Assert.assertNull((String)"The application was allowed", (Object)app2);
    }

    @Test(timeout=5000L)
    public void testMultipleNodesSingleRackRequest() throws Exception {
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, "127.0.0.1");
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 2, "127.0.0.2");
        RMNode node3 = MockNodes.newNodeInfo(2, Resources.createResource((int)1024), 3, "127.0.0.3");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId appId = this.createAppAttemptId(this.APP_ID++, this.ATTEMPT_ID++);
        this.scheduler.addApplication(appId, "queue1", "user1");
        ArrayList<ResourceRequest> asks = new ArrayList<ResourceRequest>();
        asks.add(this.createResourceRequest(1024, node1.getHostName(), 1, 1, true));
        asks.add(this.createResourceRequest(1024, node2.getHostName(), 1, 1, true));
        asks.add(this.createResourceRequest(1024, node3.getHostName(), 1, 1, true));
        asks.add(this.createResourceRequest(1024, node1.getRackName(), 1, 1, true));
        asks.add(this.createResourceRequest(1024, node3.getRackName(), 1, 1, true));
        asks.add(this.createResourceRequest(1024, "*", 1, 2, true));
        this.scheduler.allocate(appId, asks, new ArrayList(), null, null);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent1 = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent1);
        Assert.assertEquals((long)1L, (long)((FSSchedulerApp)this.scheduler.applications.get(appId)).getLiveContainers().size());
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent2 = new NodeUpdateSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)updateEvent2);
        Assert.assertEquals((long)2L, (long)((FSSchedulerApp)this.scheduler.applications.get(appId)).getLiveContainers().size());
    }

    @Test(timeout=5000L)
    public void testFifoWithinQueue() throws Exception {
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072, (int)3), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 2);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue1", "user1", 2);
        FSSchedulerApp app1 = (FSSchedulerApp)this.scheduler.applications.get(attId1);
        FSSchedulerApp app2 = (FSSchedulerApp)this.scheduler.applications.get(attId2);
        FSLeafQueue queue1 = this.scheduler.getQueueManager().getLeafQueue("queue1", true);
        queue1.setPolicy((SchedulingPolicy)new FifoPolicy());
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)app2.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)app2.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)app2.getLiveContainers().size());
    }

    @Test(timeout=3000L)
    public void testMaxAssign() throws AllocationConfigurationException {
        this.scheduler.assignMultiple = true;
        this.scheduler.getQueueManager().getLeafQueue("root.default", true).setPolicy(SchedulingPolicy.getDefault());
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)16384, (int)16), 0, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ApplicationAttemptId attId = this.createSchedulingRequest(1024, "root.default", "user", 8);
        FSSchedulerApp app = (FSSchedulerApp)this.scheduler.applications.get(attId);
        this.scheduler.maxAssign = 2;
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Incorrect number of containers allocated", (long)2L, (long)app.getLiveContainers().size());
        this.scheduler.maxAssign = -1;
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Incorrect number of containers allocated", (long)8L, (long)app.getLiveContainers().size());
    }

    @Test(timeout=5000L)
    public void testAssignContainer() throws Exception {
        String user = "user1";
        String fifoQueue = "fifo";
        String fairParent = "fairParent";
        String fairChild1 = "fairParent.fairChild1";
        String fairChild2 = "fairParent.fairChild2";
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, "127.0.0.1");
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "fifo", "user1", 4);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "fairParent.fairChild1", "user1", 4);
        ApplicationAttemptId attId3 = this.createSchedulingRequest(1024, "fairParent.fairChild2", "user1", 4);
        ApplicationAttemptId attId4 = this.createSchedulingRequest(1024, "fifo", "user1", 4);
        FSSchedulerApp app1 = (FSSchedulerApp)this.scheduler.applications.get(attId1);
        FSSchedulerApp app2 = (FSSchedulerApp)this.scheduler.applications.get(attId2);
        FSSchedulerApp app3 = (FSSchedulerApp)this.scheduler.applications.get(attId3);
        FSSchedulerApp app4 = (FSSchedulerApp)this.scheduler.applications.get(attId4);
        this.scheduler.getQueueManager().getLeafQueue("fifo", true).setPolicy(SchedulingPolicy.parse((String)"fifo"));
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent1 = new NodeUpdateSchedulerEvent(node1);
        NodeUpdateSchedulerEvent updateEvent2 = new NodeUpdateSchedulerEvent(node2);
        for (int i = 0; i < 8; ++i) {
            this.scheduler.handle((SchedulerEvent)updateEvent1);
            this.scheduler.handle((SchedulerEvent)updateEvent2);
            if ((i + 1) % 2 != 0) continue;
            String ERR = "Wrong number of assigned containers after " + (i + 1) + " updates";
            if (i < 4) {
                Assert.assertEquals((String)ERR, (long)(i + 1), (long)app1.getLiveContainers().size());
                Assert.assertEquals((String)ERR, (long)0L, (long)app4.getLiveContainers().size());
            } else {
                Assert.assertEquals((String)ERR, (long)4L, (long)app1.getLiveContainers().size());
                Assert.assertEquals((String)ERR, (long)(i - 3), (long)app4.getLiveContainers().size());
            }
            Assert.assertEquals((String)ERR, (long)((i + 1) / 2), (long)app2.getLiveContainers().size());
            Assert.assertEquals((String)ERR, (long)((i + 1) / 2), (long)app3.getLiveContainers().size());
        }
    }

    @Test
    public void testNotAllowSubmitApplication() throws Exception {
        int numTries;
        Configuration conf = this.createConfiguration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.scheduler.reinitialize(conf, this.resourceManager.getRMContext());
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queue1\">");
        out.println("<aclSubmitApps>userallow</aclSubmitApps>");
        out.println("<aclAdministerApps>userallow</aclAdministerApps>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        QueueManager queueManager = this.scheduler.getQueueManager();
        queueManager.initialize();
        int appId = this.APP_ID++;
        String user = "usernotallow";
        String queue = "queue1";
        ApplicationId applicationId = MockApps.newAppID((int)appId);
        String name = MockApps.newAppName();
        ApplicationMasterService masterService = new ApplicationMasterService(this.resourceManager.getRMContext(), (YarnScheduler)this.scheduler);
        ApplicationSubmissionContextPBImpl submissionContext = new ApplicationSubmissionContextPBImpl();
        ContainerLaunchContext clc = BuilderUtils.newContainerLaunchContext(null, null, null, null, null, null);
        submissionContext.setApplicationId(applicationId);
        submissionContext.setAMContainerSpec(clc);
        RMAppImpl application = new RMAppImpl(applicationId, this.resourceManager.getRMContext(), conf, name, user, queue, (ApplicationSubmissionContext)submissionContext, (YarnScheduler)this.scheduler, masterService, System.currentTimeMillis(), "YARN");
        this.resourceManager.getRMContext().getRMApps().putIfAbsent(applicationId, application);
        application.handle((Event)new RMAppEvent(applicationId, RMAppEventType.START));
        int MAX_TRIES = 20;
        for (numTries = 0; !application.getState().equals((Object)RMAppState.SUBMITTED) && numTries < 20; ++numTries) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        Assert.assertEquals((String)"The application doesn't reach SUBMITTED.", (Object)RMAppState.SUBMITTED, (Object)application.getState());
        ApplicationAttemptId attId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)this.ATTEMPT_ID++);
        this.scheduler.addApplication(attId, queue, user);
        for (numTries = 0; application.getFinishTime() == 0L && numTries < 20; ++numTries) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        Assert.assertEquals((Object)FinalApplicationStatus.FAILED, (Object)application.getFinalApplicationStatus());
    }

    @Test
    public void testReservationThatDoesntFit() {
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId = this.createSchedulingRequest(2048, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        FSSchedulerApp app = (FSSchedulerApp)this.scheduler.applications.get(attId);
        Assert.assertEquals((long)0L, (long)app.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)app.getReservedContainers().size());
        this.createSchedulingRequestExistingApplication(1024, 2, attId);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)app.getReservedContainers().size());
    }

    @Test
    public void testRemoveNodeUpdatesRootQueueMetrics() {
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024, (int)4), 1, "127.0.0.1");
        NodeAddedSchedulerEvent addEvent = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)addEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)4L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
        this.scheduler.update();
        Assert.assertEquals((long)1024L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)4L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
        NodeRemovedSchedulerEvent removeEvent = new NodeRemovedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)removeEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
        this.scheduler.update();
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
    }

    @Test
    public void testStrictLocality() {
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 0);
        ResourceRequest nodeRequest = this.createResourceRequest(1024, node1.getHostName(), 1, 1, true);
        ResourceRequest rackRequest = this.createResourceRequest(1024, node1.getRackName(), 1, 1, false);
        ResourceRequest anyRequest = this.createResourceRequest(1024, "*", 1, 1, false);
        this.createSchedulingRequestExistingApplication(nodeRequest, attId1);
        this.createSchedulingRequestExistingApplication(rackRequest, attId1);
        this.createSchedulingRequestExistingApplication(anyRequest, attId1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent node1UpdateEvent = new NodeUpdateSchedulerEvent(node1);
        NodeUpdateSchedulerEvent node2UpdateEvent = new NodeUpdateSchedulerEvent(node2);
        FSSchedulerApp app = (FSSchedulerApp)this.scheduler.applications.get(attId1);
        for (int i = 0; i < 10; ++i) {
            this.scheduler.handle((SchedulerEvent)node2UpdateEvent);
            Assert.assertEquals((long)0L, (long)app.getLiveContainers().size());
            Assert.assertEquals((long)0L, (long)app.getReservedContainers().size());
        }
        this.scheduler.handle((SchedulerEvent)node1UpdateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
    }

    @Test
    public void testCancelStrictLocality() {
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 0);
        ResourceRequest nodeRequest = this.createResourceRequest(1024, node1.getHostName(), 1, 1, true);
        ResourceRequest rackRequest = this.createResourceRequest(1024, "rack1", 1, 1, false);
        ResourceRequest anyRequest = this.createResourceRequest(1024, "*", 1, 1, false);
        this.createSchedulingRequestExistingApplication(nodeRequest, attId1);
        this.createSchedulingRequestExistingApplication(rackRequest, attId1);
        this.createSchedulingRequestExistingApplication(anyRequest, attId1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent node2UpdateEvent = new NodeUpdateSchedulerEvent(node2);
        FSSchedulerApp app = (FSSchedulerApp)this.scheduler.applications.get(attId1);
        for (int i = 0; i < 10; ++i) {
            this.scheduler.handle((SchedulerEvent)node2UpdateEvent);
            Assert.assertEquals((long)0L, (long)app.getLiveContainers().size());
        }
        List<ResourceRequest> update = Arrays.asList(this.createResourceRequest(1024, node1.getHostName(), 1, 0, true), this.createResourceRequest(1024, "rack1", 1, 0, true), this.createResourceRequest(1024, "*", 1, 1, true));
        this.scheduler.allocate(attId1, update, new ArrayList(), null, null);
        this.scheduler.handle((SchedulerEvent)node2UpdateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
    }

    @Test
    public void testReservationsStrictLocality() {
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, "127.0.0.1");
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attId = this.createSchedulingRequest(1024, "queue1", "user1", 0);
        FSSchedulerApp app = (FSSchedulerApp)this.scheduler.applications.get(attId);
        ResourceRequest nodeRequest = this.createResourceRequest(1024, node2.getHostName(), 1, 2, true);
        ResourceRequest rackRequest = this.createResourceRequest(1024, "rack1", 1, 2, true);
        ResourceRequest anyRequest = this.createResourceRequest(1024, "*", 1, 2, false);
        this.createSchedulingRequestExistingApplication(nodeRequest, attId);
        this.createSchedulingRequestExistingApplication(rackRequest, attId);
        this.createSchedulingRequestExistingApplication(anyRequest, attId);
        this.scheduler.update();
        NodeUpdateSchedulerEvent nodeUpdateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeUpdateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)nodeUpdateEvent);
        Assert.assertEquals((long)1L, (long)app.getReservedContainers().size());
        rackRequest = this.createResourceRequest(1024, "rack1", 1, 1, false);
        anyRequest = this.createResourceRequest(1024, "*", 1, 1, false);
        this.scheduler.allocate(attId, Arrays.asList(rackRequest, anyRequest), new ArrayList(), null, null);
        this.scheduler.handle((SchedulerEvent)nodeUpdateEvent);
        Assert.assertEquals((long)0L, (long)app.getReservedContainers().size());
    }

    public void testNoMoreCpuOnNode() {
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)2048, (int)1), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId = this.createSchedulingRequest(1024, 1, "default", "user1", 2);
        FSSchedulerApp app = (FSSchedulerApp)this.scheduler.applications.get(attId);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
    }

    public void testBasicDRFAssignment() throws Exception {
        RMNode node = MockNodes.newNodeInfo(1, BuilderUtils.newResource((int)8192, (int)5));
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ApplicationAttemptId appAttId1 = this.createSchedulingRequest(2048, 1, "queue1", "user1", 2);
        FSSchedulerApp app1 = (FSSchedulerApp)this.scheduler.applications.get(appAttId1);
        ApplicationAttemptId appAttId2 = this.createSchedulingRequest(1024, 2, "queue1", "user1", 2);
        FSSchedulerApp app2 = (FSSchedulerApp)this.scheduler.applications.get(appAttId2);
        DominantResourceFairnessPolicy drfPolicy = new DominantResourceFairnessPolicy();
        drfPolicy.initialize(this.scheduler.getClusterCapacity());
        this.scheduler.getQueueManager().getQueue("queue1").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)1, (int)app1.getLiveContainers().size());
        junit.framework.Assert.assertEquals((int)0, (int)app2.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)1, (int)app1.getLiveContainers().size());
        junit.framework.Assert.assertEquals((int)1, (int)app2.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)2, (int)app1.getLiveContainers().size());
        junit.framework.Assert.assertEquals((int)1, (int)app2.getLiveContainers().size());
    }

    @Test
    public void testBasicDRFWithQueues() throws Exception {
        RMNode node = MockNodes.newNodeInfo(1, BuilderUtils.newResource((int)8192, (int)7), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ApplicationAttemptId appAttId1 = this.createSchedulingRequest(3072, 1, "queue1", "user1", 2);
        FSSchedulerApp app1 = (FSSchedulerApp)this.scheduler.applications.get(appAttId1);
        ApplicationAttemptId appAttId2 = this.createSchedulingRequest(2048, 2, "queue1", "user1", 2);
        FSSchedulerApp app2 = (FSSchedulerApp)this.scheduler.applications.get(appAttId2);
        ApplicationAttemptId appAttId3 = this.createSchedulingRequest(1024, 2, "queue2", "user1", 2);
        FSSchedulerApp app3 = (FSSchedulerApp)this.scheduler.applications.get(appAttId3);
        DominantResourceFairnessPolicy drfPolicy = new DominantResourceFairnessPolicy();
        drfPolicy.initialize(this.scheduler.getClusterCapacity());
        this.scheduler.getQueueManager().getQueue("root").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.getQueueManager().getQueue("queue1").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)1, (int)app1.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)1, (int)app3.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)2, (int)app3.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)1, (int)app2.getLiveContainers().size());
    }

    @Test
    public void testDRFHierarchicalQueues() throws Exception {
        RMNode node = MockNodes.newNodeInfo(1, BuilderUtils.newResource((int)12288, (int)12), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ApplicationAttemptId appAttId1 = this.createSchedulingRequest(3074, 1, "queue1.subqueue1", "user1", 2);
        Thread.sleep(3L);
        FSSchedulerApp app1 = (FSSchedulerApp)this.scheduler.applications.get(appAttId1);
        ApplicationAttemptId appAttId2 = this.createSchedulingRequest(1024, 3, "queue1.subqueue1", "user1", 2);
        Thread.sleep(3L);
        FSSchedulerApp app2 = (FSSchedulerApp)this.scheduler.applications.get(appAttId2);
        ApplicationAttemptId appAttId3 = this.createSchedulingRequest(2048, 2, "queue1.subqueue2", "user1", 2);
        Thread.sleep(3L);
        FSSchedulerApp app3 = (FSSchedulerApp)this.scheduler.applications.get(appAttId3);
        ApplicationAttemptId appAttId4 = this.createSchedulingRequest(1024, 2, "queue2", "user1", 2);
        Thread.sleep(3L);
        FSSchedulerApp app4 = (FSSchedulerApp)this.scheduler.applications.get(appAttId4);
        DominantResourceFairnessPolicy drfPolicy = new DominantResourceFairnessPolicy();
        drfPolicy.initialize(this.scheduler.getClusterCapacity());
        this.scheduler.getQueueManager().getQueue("root").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.getQueueManager().getQueue("queue1").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.getQueueManager().getQueue("queue1.subqueue1").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)1, (int)app1.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)1, (int)app4.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)2, (int)app4.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)1, (int)app3.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)2, (int)app3.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)1, (int)app2.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)1, (int)app1.getLiveContainers().size());
        junit.framework.Assert.assertEquals((int)1, (int)app2.getLiveContainers().size());
        junit.framework.Assert.assertEquals((int)2, (int)app3.getLiveContainers().size());
        junit.framework.Assert.assertEquals((int)2, (int)app4.getLiveContainers().size());
    }

    @Test(timeout=30000L)
    public void testHostPortNodeName() throws Exception {
        this.scheduler.getConf().setBoolean("yarn.scheduler.include-port-in-node-name", true);
        this.scheduler.reinitialize((Configuration)this.scheduler.getConf(), this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, "127.0.0.1", 1);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 2, "127.0.0.1", 2);
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 0);
        ResourceRequest nodeRequest = this.createResourceRequest(1024, node1.getNodeID().getHost() + ":" + node1.getNodeID().getPort(), 1, 1, true);
        ResourceRequest rackRequest = this.createResourceRequest(1024, node1.getRackName(), 1, 1, false);
        ResourceRequest anyRequest = this.createResourceRequest(1024, "*", 1, 1, false);
        this.createSchedulingRequestExistingApplication(nodeRequest, attId1);
        this.createSchedulingRequestExistingApplication(rackRequest, attId1);
        this.createSchedulingRequestExistingApplication(anyRequest, attId1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent node1UpdateEvent = new NodeUpdateSchedulerEvent(node1);
        NodeUpdateSchedulerEvent node2UpdateEvent = new NodeUpdateSchedulerEvent(node2);
        FSSchedulerApp app = (FSSchedulerApp)this.scheduler.applications.get(attId1);
        for (int i = 0; i < 10; ++i) {
            this.scheduler.handle((SchedulerEvent)node2UpdateEvent);
            Assert.assertEquals((long)0L, (long)app.getLiveContainers().size());
            Assert.assertEquals((long)0L, (long)app.getReservedContainers().size());
        }
        this.scheduler.handle((SchedulerEvent)node1UpdateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
    }

    @Test
    public void testConcurrentAccessOnApplications() throws Exception {
        FairScheduler fs = new FairScheduler();
        TestCapacityScheduler.verifyConcurrentAccessOnApplications(fs.applications, FSSchedulerApp.class);
    }

    @Test
    public void testDontAllowUndeclaredPools() throws Exception {
        Configuration conf = this.createConfiguration();
        conf.setBoolean("yarn.scheduler.fair.allow-undeclared-pools", false);
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.scheduler.reinitialize(conf, this.resourceManager.getRMContext());
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"jerry\">");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        QueueManager queueManager = this.scheduler.getQueueManager();
        queueManager.initialize();
        FSLeafQueue jerryQueue = queueManager.getLeafQueue("jerry", false);
        FSLeafQueue defaultQueue = queueManager.getLeafQueue("default", false);
        this.createSchedulingRequest(1024, "jerry", "someuser");
        Assert.assertEquals((long)1L, (long)jerryQueue.getAppSchedulables().size());
        this.createSchedulingRequest(1024, "newqueue", "someuser");
        Assert.assertEquals((long)1L, (long)jerryQueue.getAppSchedulables().size());
        Assert.assertEquals((long)1L, (long)defaultQueue.getAppSchedulables().size());
        this.createSchedulingRequest(1024, "default", "someuser");
        Assert.assertEquals((long)1L, (long)jerryQueue.getAppSchedulables().size());
        Assert.assertEquals((long)2L, (long)defaultQueue.getAppSchedulables().size());
        this.createSchedulingRequest(1024, "default", "jerry");
        Assert.assertEquals((long)2L, (long)jerryQueue.getAppSchedulables().size());
        Assert.assertEquals((long)2L, (long)defaultQueue.getAppSchedulables().size());
    }

    private class MockClock
    implements Clock {
        private long time = 0L;

        private MockClock() {
        }

        public long getTime() {
            return this.time;
        }

        public void tick(int seconds) {
            this.time += (long)(seconds * 1000);
        }
    }
}

