/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestConfigurationDeprecation {
    private Configuration conf;
    static final String CONFIG = new File("./test-config-TestConfigurationDeprecation.xml").getAbsolutePath();
    static final String CONFIG2 = new File("./test-config2-TestConfigurationDeprecation.xml").getAbsolutePath();
    static final String CONFIG3 = new File("./test-config3-TestConfigurationDeprecation.xml").getAbsolutePath();
    BufferedWriter out;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration(false);
    }

    @After
    public void tearDown() throws Exception {
        new File(CONFIG).delete();
        new File(CONFIG2).delete();
        new File(CONFIG3).delete();
    }

    private void startConfig() throws IOException {
        this.out.write("<?xml version=\"1.0\"?>\n");
        this.out.write("<configuration>\n");
    }

    private void endConfig() throws IOException {
        this.out.write("</configuration>\n");
        this.out.close();
    }

    void appendProperty(String name, String val) throws IOException {
        this.appendProperty(name, val, false);
    }

    void appendProperty(String name, String val, boolean isFinal) throws IOException {
        this.out.write("<property>");
        this.out.write("<name>");
        this.out.write(name);
        this.out.write("</name>");
        this.out.write("<value>");
        this.out.write(val);
        this.out.write("</value>");
        if (isFinal) {
            this.out.write("<final>true</final>");
        }
        this.out.write("</property>\n");
    }

    private void addDeprecationToConfiguration() {
        Configuration.addDeprecation((String)"A", (String[])new String[]{"B"});
        Configuration.addDeprecation((String)"C", (String[])new String[]{"D"});
        Configuration.addDeprecation((String)"E", (String[])new String[]{"F"});
        Configuration.addDeprecation((String)"G", (String[])new String[]{"H"});
        Configuration.addDeprecation((String)"I", (String[])new String[]{"J"});
        Configuration.addDeprecation((String)"M", (String[])new String[]{"N"});
        Configuration.addDeprecation((String)"X", (String[])new String[]{"Y", "Z"});
        Configuration.addDeprecation((String)"P", (String[])new String[]{"Q", "R"});
    }

    @Test
    public void testDeprecation() throws IOException {
        this.addDeprecationToConfiguration();
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("A", "a");
        this.appendProperty("D", "d");
        this.appendProperty("P", "p");
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        Assert.assertEquals((Object)"p", (Object)this.conf.get("P"));
        Assert.assertEquals((Object)"p", (Object)this.conf.get("Q"));
        Assert.assertEquals((Object)"p", (Object)this.conf.get("R"));
        Assert.assertEquals((Object)"a", (Object)this.conf.get("A"));
        Assert.assertEquals((Object)"a", (Object)this.conf.get("B"));
        Assert.assertEquals((Object)"d", (Object)this.conf.get("C"));
        Assert.assertEquals((Object)"d", (Object)this.conf.get("D"));
        this.out = new BufferedWriter(new FileWriter(CONFIG2));
        this.startConfig();
        this.appendProperty("B", "b");
        this.appendProperty("C", "c");
        this.endConfig();
        Path fileResource1 = new Path(CONFIG2);
        this.conf.addResource(fileResource1);
        Assert.assertEquals((Object)"b", (Object)this.conf.get("A"));
        Assert.assertEquals((Object)"b", (Object)this.conf.get("B"));
        Assert.assertEquals((Object)"c", (Object)this.conf.get("C"));
        Assert.assertEquals((Object)"c", (Object)this.conf.get("D"));
        this.conf.set("N", "n");
        Assert.assertEquals((Object)"n", (Object)this.conf.get("M"));
        Assert.assertEquals((Object)this.conf.get("M"), (Object)this.conf.get("N"));
        this.conf.set("M", "m");
        Assert.assertEquals((Object)"m", (Object)this.conf.get("N"));
        this.conf.set("X", "x");
        Assert.assertEquals((Object)"x", (Object)this.conf.get("X"));
        Assert.assertEquals((Object)"x", (Object)this.conf.get("Y"));
        Assert.assertEquals((Object)"x", (Object)this.conf.get("Z"));
        this.conf.set("Y", "y");
        this.conf.set("Z", "z");
        Assert.assertEquals((Object)"z", (Object)this.conf.get("X"));
    }

    @Test
    public void testDeprecationForFinalParameters() throws IOException {
        this.addDeprecationToConfiguration();
        this.out = new BufferedWriter(new FileWriter(CONFIG));
        this.startConfig();
        this.appendProperty("A", "a", true);
        this.appendProperty("D", "d");
        this.appendProperty("E", "e");
        this.appendProperty("H", "h", true);
        this.appendProperty("J", "", true);
        this.endConfig();
        Path fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        Assert.assertEquals((Object)"a", (Object)this.conf.get("A"));
        Assert.assertEquals((Object)"a", (Object)this.conf.get("B"));
        Assert.assertEquals((Object)"d", (Object)this.conf.get("C"));
        Assert.assertEquals((Object)"d", (Object)this.conf.get("D"));
        Assert.assertEquals((Object)"e", (Object)this.conf.get("E"));
        Assert.assertEquals((Object)"e", (Object)this.conf.get("F"));
        Assert.assertEquals((Object)"h", (Object)this.conf.get("G"));
        Assert.assertEquals((Object)"h", (Object)this.conf.get("H"));
        Assert.assertNull((Object)this.conf.get("I"));
        Assert.assertNull((Object)this.conf.get("J"));
        this.out = new BufferedWriter(new FileWriter(CONFIG2));
        this.startConfig();
        this.appendProperty("B", "b");
        this.appendProperty("C", "c", true);
        this.appendProperty("F", "f", true);
        this.appendProperty("G", "g");
        this.appendProperty("I", "i");
        this.endConfig();
        Path fileResource1 = new Path(CONFIG2);
        this.conf.addResource(fileResource1);
        Assert.assertEquals((Object)"a", (Object)this.conf.get("A"));
        Assert.assertEquals((Object)"a", (Object)this.conf.get("B"));
        Assert.assertEquals((Object)"c", (Object)this.conf.get("C"));
        Assert.assertEquals((Object)"c", (Object)this.conf.get("D"));
        Assert.assertEquals((Object)"f", (Object)this.conf.get("E"));
        Assert.assertEquals((Object)"f", (Object)this.conf.get("F"));
        Assert.assertEquals((Object)"h", (Object)this.conf.get("G"));
        Assert.assertEquals((Object)"h", (Object)this.conf.get("H"));
        Assert.assertNull((Object)this.conf.get("I"));
        Assert.assertNull((Object)this.conf.get("J"));
        this.out = new BufferedWriter(new FileWriter(CONFIG3));
        this.startConfig();
        this.appendProperty("A", "a1");
        this.appendProperty("B", "b1");
        this.appendProperty("C", "c1");
        this.appendProperty("D", "d1");
        this.appendProperty("E", "e1");
        this.appendProperty("F", "f1");
        this.appendProperty("G", "g1");
        this.appendProperty("H", "h1");
        this.appendProperty("I", "i1");
        this.appendProperty("J", "j1");
        this.endConfig();
        fileResource = new Path(CONFIG);
        this.conf.addResource(fileResource);
        Assert.assertEquals((Object)"a", (Object)this.conf.get("A"));
        Assert.assertEquals((Object)"a", (Object)this.conf.get("B"));
        Assert.assertEquals((Object)"c", (Object)this.conf.get("C"));
        Assert.assertEquals((Object)"c", (Object)this.conf.get("D"));
        Assert.assertEquals((Object)"f", (Object)this.conf.get("E"));
        Assert.assertEquals((Object)"f", (Object)this.conf.get("F"));
        Assert.assertEquals((Object)"h", (Object)this.conf.get("G"));
        Assert.assertEquals((Object)"h", (Object)this.conf.get("H"));
        Assert.assertNull((Object)this.conf.get("I"));
        Assert.assertNull((Object)this.conf.get("J"));
    }

    @Test
    public void testSetBeforeAndGetAfterDeprecation() {
        Configuration conf = new Configuration();
        conf.set("oldkey", "hello");
        Configuration.addDeprecation((String)"oldkey", (String[])new String[]{"newkey"});
        Assert.assertEquals((Object)"hello", (Object)conf.get("newkey"));
    }

    @Test
    public void testSetBeforeAndGetAfterDeprecationAndDefaults() {
        Configuration conf = new Configuration();
        conf.set("tests.fake-default.old-key", "hello");
        Configuration.addDeprecation((String)"tests.fake-default.old-key", (String[])new String[]{"tests.fake-default.new-key"});
        Assert.assertEquals((Object)"hello", (Object)conf.get("tests.fake-default.new-key"));
    }

    @Test
    public void testIteratorWithDeprecatedKeys() {
        Configuration conf = new Configuration();
        Configuration.addDeprecation((String)"dK", (String[])new String[]{"nK"});
        conf.set("k", "v");
        conf.set("dK", "V");
        Assert.assertEquals((Object)"V", (Object)conf.get("dK"));
        Assert.assertEquals((Object)"V", (Object)conf.get("nK"));
        conf.set("nK", "VV");
        Assert.assertEquals((Object)"VV", (Object)conf.get("dK"));
        Assert.assertEquals((Object)"VV", (Object)conf.get("nK"));
        boolean kFound = false;
        boolean dKFound = false;
        boolean nKFound = false;
        for (Map.Entry entry : conf) {
            if (((String)entry.getKey()).equals("k")) {
                Assert.assertEquals((Object)"v", entry.getValue());
                kFound = true;
            }
            if (((String)entry.getKey()).equals("dK")) {
                Assert.assertEquals((Object)"VV", entry.getValue());
                dKFound = true;
            }
            if (!((String)entry.getKey()).equals("nK")) continue;
            Assert.assertEquals((Object)"VV", entry.getValue());
            nKFound = true;
        }
        Assert.assertTrue((String)"regular Key not found", (boolean)kFound);
        Assert.assertTrue((String)"deprecated Key not found", (boolean)dKFound);
        Assert.assertTrue((String)"new Key not found", (boolean)nKFound);
    }

    @Test
    public void testUnsetWithDeprecatedKeys() {
        Configuration conf = new Configuration();
        Configuration.addDeprecation((String)"dK", (String[])new String[]{"nK"});
        conf.set("nK", "VV");
        Assert.assertEquals((Object)"VV", (Object)conf.get("dK"));
        Assert.assertEquals((Object)"VV", (Object)conf.get("nK"));
        conf.unset("dK");
        Assert.assertNull((Object)conf.get("dK"));
        Assert.assertNull((Object)conf.get("nK"));
        conf.set("nK", "VV");
        Assert.assertEquals((Object)"VV", (Object)conf.get("dK"));
        Assert.assertEquals((Object)"VV", (Object)conf.get("nK"));
        conf.unset("nK");
        Assert.assertNull((Object)conf.get("dK"));
        Assert.assertNull((Object)conf.get("nK"));
    }

    static {
        Configuration.addDefaultResource((String)"test-fake-default.xml");
    }
}

