/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.junit.Assert;
import org.junit.Test;

public class TestSmallBlock {
    static final long seed = 3735928559L;
    static final int blockSize = 1;
    static final int fileSize = 20;
    boolean simulatedStorage = false;

    private void writeFile(FileSystem fileSys, Path name) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)1, 1L);
        byte[] buffer = new byte[20];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    private void checkAndEraseData(byte[] actual, int from, byte[] expected, String message) {
        for (int idx = 0; idx < actual.length; ++idx) {
            Assert.assertEquals((String)(message + " byte " + (from + idx) + " differs. expected " + expected[from + idx] + " actual " + actual[idx]), (long)actual[idx], (long)expected[from + idx]);
            actual[idx] = 0;
        }
    }

    private void checkFile(FileSystem fileSys, Path name) throws IOException {
        BlockLocation[] locations = fileSys.getFileBlockLocations(fileSys.getFileStatus(name), 0L, 20L);
        Assert.assertEquals((String)"Number of blocks", (long)20L, (long)locations.length);
        FSDataInputStream stm = fileSys.open(name);
        byte[] expected = new byte[20];
        if (this.simulatedStorage) {
            for (int i = 0; i < expected.length; ++i) {
                expected[i] = 9;
            }
        } else {
            Random rand = new Random(3735928559L);
            rand.nextBytes(expected);
        }
        byte[] actual = new byte[20];
        stm.readFully(0L, actual);
        this.checkAndEraseData(actual, 0, expected, "Read Sanity Test");
        stm.close();
    }

    private void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        Assert.assertTrue((boolean)fileSys.exists(name));
        fileSys.delete(name, true);
        Assert.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSmallBlock() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        if (this.simulatedStorage) {
            SimulatedFSDataset.setFactory((Configuration)conf);
        }
        conf.set("dfs.bytes-per-checksum", "1");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fileSys = cluster.getFileSystem();
        try {
            Path file1 = new Path("smallblocktest.dat");
            this.writeFile((FileSystem)fileSys, file1);
            this.checkFile((FileSystem)fileSys, file1);
            this.cleanupFile((FileSystem)fileSys, file1);
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
    }

    @Test
    public void testSmallBlockSimulatedStorage() throws IOException {
        this.simulatedStorage = true;
        this.testSmallBlock();
        this.simulatedStorage = false;
    }
}

