/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.FSLimitException;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryWithQuota;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestFsLimits {
    static Configuration conf;
    static INode[] inodes;
    static FSDirectory fs;
    static boolean fsIsReady;
    static PermissionStatus perms;
    static INodeDirectoryWithQuota rootInode;

    private static FSNamesystem getMockNamesystem() {
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)fsn.createFsOwnerPermissions((FsPermission)Matchers.anyObject())).thenReturn((Object)new PermissionStatus("root", "wheel", FsPermission.getDefault()));
        return fsn;
    }

    @Before
    public void setUp() throws IOException {
        conf = new Configuration();
        conf.set("dfs.namenode.name.dir", Util.fileAsURI((File)new File(MiniDFSCluster.getBaseDirectory(), "namenode")).toString());
        rootInode = new INodeDirectoryWithQuota(TestFsLimits.getMockNamesystem().allocateNewInodeId(), INodeDirectory.ROOT_NAME, perms);
        inodes = new INode[]{rootInode, null};
        fs = null;
        fsIsReady = true;
    }

    @Test
    public void testDefaultMaxComponentLength() {
        int maxComponentLength = conf.getInt("dfs.namenode.fs-limits.max-component-length", 0);
        Assert.assertEquals((long)0L, (long)maxComponentLength);
    }

    @Test
    public void testDefaultMaxDirItems() {
        int maxDirItems = conf.getInt("dfs.namenode.fs-limits.max-directory-items", 0);
        Assert.assertEquals((long)0L, (long)maxDirItems);
    }

    @Test
    public void testNoLimits() throws Exception {
        this.addChildWithName("1", null);
        this.addChildWithName("22", null);
        this.addChildWithName("333", null);
        this.addChildWithName("4444", null);
        this.addChildWithName("55555", null);
        this.addChildWithName(".snapshot", HadoopIllegalArgumentException.class);
    }

    @Test
    public void testMaxComponentLength() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-component-length", 2);
        this.addChildWithName("1", null);
        this.addChildWithName("22", null);
        this.addChildWithName("333", FSLimitException.PathComponentTooLongException.class);
        this.addChildWithName("4444", FSLimitException.PathComponentTooLongException.class);
    }

    @Test
    public void testMaxDirItems() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-directory-items", 2);
        this.addChildWithName("1", null);
        this.addChildWithName("22", null);
        this.addChildWithName("333", FSLimitException.MaxDirectoryItemsExceededException.class);
        this.addChildWithName("4444", FSLimitException.MaxDirectoryItemsExceededException.class);
    }

    @Test
    public void testMaxComponentsAndMaxDirItems() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-component-length", 3);
        conf.setInt("dfs.namenode.fs-limits.max-directory-items", 2);
        this.addChildWithName("1", null);
        this.addChildWithName("22", null);
        this.addChildWithName("333", FSLimitException.MaxDirectoryItemsExceededException.class);
        this.addChildWithName("4444", FSLimitException.PathComponentTooLongException.class);
    }

    @Test
    public void testDuringEditLogs() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-component-length", 3);
        conf.setInt("dfs.namenode.fs-limits.max-directory-items", 2);
        fsIsReady = false;
        this.addChildWithName(".snapshot", HadoopIllegalArgumentException.class);
        this.addChildWithName("1", null);
        this.addChildWithName("22", null);
        this.addChildWithName("333", null);
        this.addChildWithName("4444", null);
    }

    private void addChildWithName(String name, Class<?> expected) throws Exception {
        if (fs == null) {
            fs = new MockFSDirectory();
        }
        INodeDirectory child = new INodeDirectory(TestFsLimits.getMockNamesystem().allocateNewInodeId(), DFSUtil.string2Bytes((String)name), perms, 0L);
        Class<?> generated = null;
        try {
            fs.verifyMaxComponentLength(child.getLocalNameBytes(), (Object)inodes, 1);
            fs.verifyMaxDirItems(inodes, 1);
            fs.verifyINodeName(child.getLocalNameBytes());
            rootInode.addChild((INode)child);
        }
        catch (Throwable e) {
            generated = e.getClass();
        }
        Assert.assertEquals(expected, generated);
    }

    static {
        perms = new PermissionStatus("admin", "admin", FsPermission.getDefault());
    }

    private static class MockFSDirectory
    extends FSDirectory {
        public MockFSDirectory() throws IOException {
            super(new FSImage(conf), TestFsLimits.getMockNamesystem(), conf);
            this.setReady(fsIsReady);
        }
    }
}

