/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.view;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.hadoop.yarn.webapp.ResponseInfo;
import org.apache.hadoop.yarn.webapp.test.WebAppTests;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestInfoBlock {
    public static StringWriter sw;
    public static PrintWriter pw;

    @Before
    public void setup() {
        sw = new StringWriter();
        pw = new PrintWriter(sw);
    }

    @Test(timeout=60000L)
    public void testMultilineInfoBlock() throws Exception {
        WebAppTests.testBlock(MultilineInfoBlock.class);
        pw.flush();
        String output = sw.toString().replaceAll(" +", " ");
        String expectedSinglelineData = String.format("<tr class=\"odd\">%n <th>%n Single_line_value%n <td>%n This is one line.%n", new Object[0]);
        String expectedMultilineData = String.format("<tr class=\"even\">%n <th>%n Multiple_line_value%n <td>%n <div>%n This is first line.%n </div>%n <div>%n This is second line.%n </div>%n", new Object[0]);
        Assert.assertTrue((output.contains(expectedSinglelineData) && output.contains(expectedMultilineData) ? 1 : 0) != 0);
    }

    public static class MultilineInfoBlock
    extends InfoBlock {
        static ResponseInfo resInfo = new ResponseInfo();

        public PrintWriter writer() {
            return pw;
        }

        MultilineInfoBlock(ResponseInfo info) {
            super(resInfo);
        }

        public MultilineInfoBlock() {
            super(resInfo);
        }

        static {
            resInfo._("Single_line_value", (Object)"This is one line.");
            resInfo._("Multiple_line_value", (Object)"This is first line.\nThis is second line.");
        }
    }
}

