/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.mount;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.mount.MountEntry;
import org.apache.hadoop.mount.MountInterface;
import org.apache.hadoop.mount.MountResponse;
import org.apache.hadoop.nfs.AccessPrivilege;
import org.apache.hadoop.nfs.NfsExports;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.oncrpc.RpcAcceptedReply;
import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.RpcInfo;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.oncrpc.RpcResponse;
import org.apache.hadoop.oncrpc.RpcUtil;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Verifier;
import org.apache.hadoop.oncrpc.security.VerifierNone;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;

public class RpcProgramMountd
extends RpcProgram
implements MountInterface {
    private static final Log LOG = LogFactory.getLog(RpcProgramMountd.class);
    public static final int PROGRAM = 100005;
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final int VERSION_3 = 3;
    public static final int PORT = 4242;
    private final DFSClient dfsClient;
    private final List<MountEntry> mounts;
    private final List<String> exports;
    private final NfsExports hostsMatcher;

    public RpcProgramMountd() throws IOException {
        this(new ArrayList<String>(0));
    }

    public RpcProgramMountd(List<String> exports) throws IOException {
        this(exports, new Configuration());
    }

    public RpcProgramMountd(List<String> exports, Configuration config) throws IOException {
        super("mountd", "localhost", config.getInt("nfs3.mountd.port", 4242), 100005, 1, 3);
        this.hostsMatcher = NfsExports.getInstance((Configuration)config);
        this.mounts = Collections.synchronizedList(new ArrayList());
        this.exports = Collections.unmodifiableList(exports);
        this.dfsClient = new DFSClient(NameNode.getAddress((Configuration)config), config);
    }

    public XDR nullOp(XDR out, int xid, InetAddress client) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MOUNT NULLOP :  client: " + client));
        }
        return RpcAcceptedReply.getAcceptInstance((int)xid, (Verifier)new VerifierNone()).write(out);
    }

    public XDR mnt(XDR xdr, XDR out, int xid, InetAddress client) {
        AccessPrivilege accessPrivilege = this.hostsMatcher.getAccessPrivilege(client);
        if (accessPrivilege == AccessPrivilege.NONE) {
            return MountResponse.writeMNTResponse((int)13, (XDR)out, (int)xid, null);
        }
        String path = xdr.readString();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MOUNT MNT path: " + path + " client: " + client));
        }
        String host = client.getHostName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Got host: " + host + " path: " + path));
        }
        if (!this.exports.contains(path)) {
            LOG.info((Object)("Path " + path + " is not shared."));
            MountResponse.writeMNTResponse((int)2, (XDR)out, (int)xid, null);
            return out;
        }
        FileHandle handle = null;
        try {
            HdfsFileStatus exFileStatus = this.dfsClient.getFileInfo(path);
            handle = new FileHandle(exFileStatus.getFileId());
        }
        catch (IOException e) {
            LOG.error((Object)("Can't get handle for export:" + path + ", exception:" + e));
            MountResponse.writeMNTResponse((int)2, (XDR)out, (int)xid, null);
            return out;
        }
        assert (handle != null);
        LOG.info((Object)("Giving handle (fileId:" + handle.getFileId() + ") to client for export " + path));
        this.mounts.add(new MountEntry(host, path));
        MountResponse.writeMNTResponse((int)0, (XDR)out, (int)xid, (byte[])handle.getContent());
        return out;
    }

    public XDR dump(XDR out, int xid, InetAddress client) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MOUNT NULLOP :  client: " + client));
        }
        ArrayList<MountEntry> copy = new ArrayList<MountEntry>(this.mounts);
        MountResponse.writeMountList((XDR)out, (int)xid, copy);
        return out;
    }

    public XDR umnt(XDR xdr, XDR out, int xid, InetAddress client) {
        String path = xdr.readString();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MOUNT UMNT path: " + path + " client: " + client));
        }
        String host = client.getHostName();
        this.mounts.remove(new MountEntry(host, path));
        RpcAcceptedReply.getAcceptInstance((int)xid, (Verifier)new VerifierNone()).write(out);
        return out;
    }

    public XDR umntall(XDR out, int xid, InetAddress client) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MOUNT UMNTALL :  client: " + client));
        }
        this.mounts.clear();
        return RpcAcceptedReply.getAcceptInstance((int)xid, (Verifier)new VerifierNone()).write(out);
    }

    public void handleInternal(ChannelHandlerContext ctx, RpcInfo info) {
        RpcCall rpcCall = (RpcCall)info.header();
        MountInterface.MNTPROC mntproc = MountInterface.MNTPROC.fromValue((int)rpcCall.getProcedure());
        int xid = rpcCall.getXid();
        byte[] data = new byte[info.data().readableBytes()];
        info.data().readBytes(data);
        XDR xdr = new XDR(data);
        XDR out = new XDR();
        InetAddress client = ((InetSocketAddress)info.remoteAddress()).getAddress();
        if (mntproc == MountInterface.MNTPROC.NULL) {
            out = this.nullOp(out, xid, client);
        } else if (mntproc == MountInterface.MNTPROC.MNT) {
            out = this.mnt(xdr, out, xid, client);
        } else if (mntproc == MountInterface.MNTPROC.DUMP) {
            out = this.dump(out, xid, client);
        } else if (mntproc == MountInterface.MNTPROC.UMNT) {
            out = this.umnt(xdr, out, xid, client);
        } else if (mntproc == MountInterface.MNTPROC.UMNTALL) {
            this.umntall(out, xid, client);
        } else if (mntproc == MountInterface.MNTPROC.EXPORT) {
            ArrayList<NfsExports> hostsMatchers = new ArrayList<NfsExports>();
            hostsMatchers.add(this.hostsMatcher);
            out = MountResponse.writeExportList((XDR)out, (int)xid, this.exports, hostsMatchers);
        } else {
            RpcAcceptedReply.getInstance((int)xid, (RpcAcceptedReply.AcceptState)RpcAcceptedReply.AcceptState.PROC_UNAVAIL, (Verifier)new VerifierNone()).write(out);
        }
        ChannelBuffer buf = ChannelBuffers.wrappedBuffer((ByteBuffer)out.asReadOnlyWrap().buffer());
        RpcResponse rsp = new RpcResponse(buf, info.remoteAddress());
        RpcUtil.sendRpcResponse((ChannelHandlerContext)ctx, (RpcResponse)rsp);
    }

    protected boolean isIdempotent(RpcCall call) {
        return false;
    }
}

