/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.security.UserGroupInformation;

class DFSClientCache {
    private static final Log LOG = LogFactory.getLog(DFSClientCache.class);
    @VisibleForTesting
    final LoadingCache<String, DFSClient> clientCache;
    static final int DEFAULT_DFS_CLIENT_CACHE_SIZE = 256;
    private final Configuration config;

    DFSClientCache(Configuration config) {
        this(config, 256);
    }

    DFSClientCache(Configuration config, int clientCache) {
        this.config = config;
        this.clientCache = CacheBuilder.newBuilder().maximumSize((long)clientCache).removalListener(this.clientRemovealListener()).build(this.clientLoader());
    }

    private CacheLoader<String, DFSClient> clientLoader() {
        return new CacheLoader<String, DFSClient>(){

            public DFSClient load(String userName) throws Exception {
                UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)userName);
                return (DFSClient)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<DFSClient>(){

                    @Override
                    public DFSClient run() throws IOException {
                        return new DFSClient(NameNode.getAddress((Configuration)DFSClientCache.this.config), DFSClientCache.this.config);
                    }
                });
            }
        };
    }

    private RemovalListener<String, DFSClient> clientRemovealListener() {
        return new RemovalListener<String, DFSClient>(){

            public void onRemoval(RemovalNotification<String, DFSClient> notification) {
                DFSClient client = (DFSClient)notification.getValue();
                try {
                    client.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)String.format("IOException when closing the DFSClient(%s), cause: %s", client, e));
                }
            }
        };
    }

    DFSClient get(String userName) {
        DFSClient client = null;
        try {
            client = (DFSClient)this.clientCache.get((Object)userName);
        }
        catch (ExecutionException e) {
            LOG.error((Object)("Failed to create DFSClient for user:" + userName + " Cause:" + e));
        }
        return client;
    }
}

