/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.nfs.nfs3.AsyncDataService;
import org.apache.hadoop.hdfs.nfs.nfs3.Nfs3Utils;
import org.apache.hadoop.hdfs.nfs.nfs3.OpenFileCtx;
import org.apache.hadoop.nfs.NfsFileType;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.IdUserGroup;
import org.apache.hadoop.nfs.nfs3.Nfs3Constant;
import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.request.WRITE3Request;
import org.apache.hadoop.nfs.nfs3.response.WRITE3Response;
import org.apache.hadoop.nfs.nfs3.response.WccData;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Verifier;
import org.apache.hadoop.oncrpc.security.VerifierNone;
import org.apache.hadoop.util.Daemon;
import org.jboss.netty.channel.Channel;

public class WriteManager {
    public static final Log LOG = LogFactory.getLog(WriteManager.class);
    private final Configuration config;
    private final IdUserGroup iug;
    private final ConcurrentMap<FileHandle, OpenFileCtx> openFileMap = Maps.newConcurrentMap();
    private AsyncDataService asyncDataService;
    private boolean asyncDataServiceStarted = false;
    private final StreamMonitor streamMonitor;
    private long streamTimeout;
    public static final long DEFAULT_STREAM_TIMEOUT = 600000L;
    public static final long MINIMIUM_STREAM_TIMEOUT = 10000L;

    void addOpenFileStream(FileHandle h, OpenFileCtx ctx) {
        this.openFileMap.put(h, ctx);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("After add the new stream " + h.getFileId() + ", the stream number:" + this.openFileMap.size()));
        }
    }

    WriteManager(IdUserGroup iug, Configuration config) {
        this.iug = iug;
        this.config = config;
        this.streamTimeout = config.getLong("dfs.nfs3.stream.timeout", 600000L);
        LOG.info((Object)("Stream timeout is " + this.streamTimeout + "ms."));
        if (this.streamTimeout < 10000L) {
            LOG.info((Object)"Reset stream timeout to minimum value 10000ms.");
            this.streamTimeout = 10000L;
        }
        this.streamMonitor = new StreamMonitor();
    }

    private void startAsyncDataSerivce() {
        this.streamMonitor.start();
        this.asyncDataService = new AsyncDataService();
        this.asyncDataServiceStarted = true;
    }

    private void shutdownAsyncDataService() {
        this.asyncDataService.shutdown();
        this.asyncDataServiceStarted = false;
        this.streamMonitor.interrupt();
    }

    void handleWrite(DFSClient dfsClient, WRITE3Request request, Channel channel, int xid, Nfs3FileAttributes preOpAttr) throws IOException {
        FileHandle fileHandle;
        OpenFileCtx openFileCtx;
        if (!this.asyncDataServiceStarted) {
            this.startAsyncDataSerivce();
        }
        long offset = request.getOffset();
        int count = request.getCount();
        Nfs3Constant.WriteStableHow stableHow = request.getStableHow();
        byte[] data = request.getData().array();
        if (data.length < count) {
            WRITE3Response response = new WRITE3Response(22);
            Nfs3Utils.writeChannel(channel, response.writeHeaderAndResponse(new XDR(), xid, (Verifier)new VerifierNone()), xid);
            return;
        }
        FileHandle handle = request.getHandle();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("handleWrite fileId: " + handle.getFileId() + " offset: " + offset + " length:" + count + " stableHow:" + stableHow.getValue()));
        }
        if ((openFileCtx = (OpenFileCtx)this.openFileMap.get(fileHandle = request.getHandle())) == null) {
            LOG.info((Object)("No opened stream for fileId:" + fileHandle.getFileId()));
            String fileIdPath = Nfs3Utils.getFileIdPath(fileHandle.getFileId());
            HdfsDataOutputStream fos = null;
            Nfs3FileAttributes latestAttr = null;
            try {
                int bufferSize = this.config.getInt("io.file.buffer.size", 4096);
                fos = dfsClient.append(fileIdPath, bufferSize, null, null);
                latestAttr = Nfs3Utils.getFileAttr(dfsClient, fileIdPath, this.iug);
            }
            catch (IOException e) {
                LOG.error((Object)("Can't apapend to file:" + fileIdPath + ", error:" + e));
                if (fos != null) {
                    fos.close();
                }
                WccData fileWcc = new WccData(Nfs3Utils.getWccAttr(preOpAttr), preOpAttr);
                WRITE3Response response = new WRITE3Response(5, fileWcc, count, request.getStableHow(), Nfs3Constant.WRITE_COMMIT_VERF);
                Nfs3Utils.writeChannel(channel, response.writeHeaderAndResponse(new XDR(), xid, (Verifier)new VerifierNone()), xid);
                return;
            }
            String writeDumpDir = this.config.get("dfs.nfs3.dump.dir", "/tmp/.hdfs-nfs");
            openFileCtx = new OpenFileCtx(fos, latestAttr, writeDumpDir + "/" + fileHandle.getFileId());
            this.addOpenFileStream(fileHandle, openFileCtx);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("opened stream for file:" + fileHandle.getFileId()));
            }
        }
        openFileCtx.receivedNewWrite(dfsClient, request, channel, xid, this.asyncDataService, this.iug);
        if (request.getStableHow() != Nfs3Constant.WriteStableHow.UNSTABLE) {
            if (this.handleCommit(fileHandle, offset + (long)count)) {
                Nfs3FileAttributes postOpAttr = this.getFileAttr(dfsClient, handle, this.iug);
                WccData fileWcc = new WccData(Nfs3Utils.getWccAttr(preOpAttr), postOpAttr);
                WRITE3Response response = new WRITE3Response(0, fileWcc, count, request.getStableHow(), Nfs3Constant.WRITE_COMMIT_VERF);
                Nfs3Utils.writeChannel(channel, response.writeHeaderAndResponse(new XDR(), xid, (Verifier)new VerifierNone()), xid);
            } else {
                WRITE3Response response = new WRITE3Response(5);
                Nfs3Utils.writeChannel(channel, response.writeHeaderAndResponse(new XDR(), xid, (Verifier)new VerifierNone()), xid);
            }
        }
    }

    boolean handleCommit(FileHandle fileHandle, long commitOffset) {
        OpenFileCtx openFileCtx = (OpenFileCtx)this.openFileMap.get(fileHandle);
        if (openFileCtx == null) {
            LOG.info((Object)("No opened stream for fileId:" + fileHandle.getFileId() + " commitOffset=" + commitOffset));
            return true;
        }
        long timeout = 30000L;
        long startCommit = System.currentTimeMillis();
        int ret;
        while ((ret = openFileCtx.checkCommit(commitOffset)) != 0) {
            if (ret == 2) {
                LOG.info((Object)("Inactive stream, fileId=" + fileHandle.getFileId() + " commitOffset=" + commitOffset));
                return true;
            }
            if (ret == 3) {
                LOG.info((Object)("Inactive stream with pending writes, fileId=" + fileHandle.getFileId() + " commitOffset=" + commitOffset));
                return false;
            }
            assert (ret == 1 || ret == 4);
            if (ret == 4) {
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not committed yet, wait., fileId=" + fileHandle.getFileId() + " commitOffset=" + commitOffset));
            }
            if (System.currentTimeMillis() - startCommit > timeout) {
                return false;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOG.info((Object)("Commit is interrupted, fileId=" + fileHandle.getFileId() + " commitOffset=" + commitOffset));
                return false;
            }
        }
        return true;
    }

    Nfs3FileAttributes getFileAttr(DFSClient client, FileHandle fileHandle, IdUserGroup iug) throws IOException {
        OpenFileCtx openFileCtx;
        String fileIdPath = Nfs3Utils.getFileIdPath(fileHandle);
        Nfs3FileAttributes attr = Nfs3Utils.getFileAttr(client, fileIdPath, iug);
        if (attr != null && (openFileCtx = (OpenFileCtx)this.openFileMap.get(fileHandle)) != null) {
            attr.setSize(openFileCtx.getNextOffset());
            attr.setUsed(openFileCtx.getNextOffset());
        }
        return attr;
    }

    Nfs3FileAttributes getFileAttr(DFSClient client, FileHandle dirHandle, String fileName) throws IOException {
        OpenFileCtx openFileCtx;
        String fileIdPath = Nfs3Utils.getFileIdPath(dirHandle) + "/" + fileName;
        Nfs3FileAttributes attr = Nfs3Utils.getFileAttr(client, fileIdPath, this.iug);
        if (attr != null && attr.getType() == NfsFileType.NFSREG.toValue() && (openFileCtx = (OpenFileCtx)this.openFileMap.get(new FileHandle(attr.getFileId()))) != null) {
            attr.setSize(openFileCtx.getNextOffset());
            attr.setUsed(openFileCtx.getNextOffset());
        }
        return attr;
    }

    class StreamMonitor
    extends Daemon {
        private int rotation = 5000;
        private long lastWakeupTime = 0L;

        StreamMonitor() {
        }

        public void run() {
            while (true) {
                Iterator it = WriteManager.this.openFileMap.entrySet().iterator();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("openFileMap size:" + WriteManager.this.openFileMap.size()));
                }
                while (it.hasNext()) {
                    Map.Entry pairs = it.next();
                    OpenFileCtx ctx = (OpenFileCtx)pairs.getValue();
                    if (!ctx.streamCleanup(((FileHandle)pairs.getKey()).getFileId(), WriteManager.this.streamTimeout)) continue;
                    it.remove();
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("After remove stream " + ((FileHandle)pairs.getKey()).getFileId() + ", the stream number:" + WriteManager.this.openFileMap.size()));
                }
                try {
                    long workedTime = System.currentTimeMillis() - this.lastWakeupTime;
                    if (workedTime < (long)this.rotation) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("StreamMonitor can still have a sleep:" + ((long)this.rotation - workedTime) / 1000L));
                        }
                        Thread.sleep((long)this.rotation - workedTime);
                    }
                    this.lastWakeupTime = System.currentTimeMillis();
                }
                catch (InterruptedException e) {
                    LOG.info((Object)"StreamMonitor got interrupted");
                    return;
                }
            }
        }
    }
}

