/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.ClusterInfo;
import org.apache.hadoop.mapreduce.v2.app.MockJobs;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenSecretManager;
import org.apache.hadoop.yarn.util.Clock;

public class MockAppContext
implements AppContext {
    final ApplicationAttemptId appAttemptID;
    final ApplicationId appID;
    final String user = MockJobs.newUserName();
    final Map<JobId, Job> jobs;
    final long startTime = System.currentTimeMillis();
    Set<String> blacklistedNodes;

    public MockAppContext(int appid) {
        this.appID = MockJobs.newAppID((int)appid);
        this.appAttemptID = ApplicationAttemptId.newInstance((ApplicationId)this.appID, (int)0);
        this.jobs = null;
    }

    public MockAppContext(int appid, int numTasks, int numAttempts, Path confPath) {
        this.appID = MockJobs.newAppID((int)appid);
        this.appAttemptID = ApplicationAttemptId.newInstance((ApplicationId)this.appID, (int)0);
        HashMap map = Maps.newHashMap();
        Job job = MockJobs.newJob(this.appID, 0, numTasks, numAttempts, confPath);
        map.put(job.getID(), job);
        this.jobs = map;
    }

    public MockAppContext(int appid, int numJobs, int numTasks, int numAttempts) {
        this(appid, numJobs, numTasks, numAttempts, false);
    }

    public MockAppContext(int appid, int numJobs, int numTasks, int numAttempts, boolean hasFailedTasks) {
        this.appID = MockJobs.newAppID((int)appid);
        this.appAttemptID = ApplicationAttemptId.newInstance((ApplicationId)this.appID, (int)0);
        this.jobs = MockJobs.newJobs(this.appID, numJobs, numTasks, numAttempts, hasFailedTasks);
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.appAttemptID;
    }

    public ApplicationId getApplicationID() {
        return this.appID;
    }

    public CharSequence getUser() {
        return this.user;
    }

    public Job getJob(JobId jobID) {
        return this.jobs.get(jobID);
    }

    public Map<JobId, Job> getAllJobs() {
        return this.jobs;
    }

    public EventHandler getEventHandler() {
        return null;
    }

    public Clock getClock() {
        return null;
    }

    public String getApplicationName() {
        return "TestApp";
    }

    public long getStartTime() {
        return this.startTime;
    }

    public ClusterInfo getClusterInfo() {
        return null;
    }

    public Set<String> getBlacklistedNodes() {
        return this.blacklistedNodes;
    }

    public void setBlacklistedNodes(Set<String> blacklistedNodes) {
        this.blacklistedNodes = blacklistedNodes;
    }

    public ClientToAMTokenSecretManager getClientToAMTokenSecretManager() {
        return null;
    }

    public boolean isLastAMRetry() {
        return false;
    }

    public boolean hasSuccessfullyUnregistered() {
        return true;
    }
}

