/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.commit;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterEvent;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterEventHandler;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterJobCommitEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobCommitCompletedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobCommitFailedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.rm.RMHeartbeatHandler;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestCommitterEventHandler {
    static String stagingDir = "target/test-staging/";

    @BeforeClass
    public static void setup() {
        File dir = new File(stagingDir);
        stagingDir = dir.getAbsolutePath();
    }

    @Before
    public void cleanup() throws IOException {
        File dir = new File(stagingDir);
        if (dir.exists()) {
            FileUtils.deleteDirectory((File)dir);
        }
        dir.mkdirs();
    }

    @Test
    public void testCommitWindow() throws Exception {
        long timeToWaitMs;
        Configuration conf = new Configuration();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        AsyncDispatcher dispatcher = new AsyncDispatcher();
        dispatcher.init(conf);
        dispatcher.start();
        TestingJobEventHandler jeh = new TestingJobEventHandler();
        dispatcher.register(JobEventType.class, (EventHandler)jeh);
        SystemClock clock = new SystemClock();
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        ApplicationAttemptId attemptid = ConverterUtils.toApplicationAttemptId((String)"appattempt_1234567890000_0001_0");
        Mockito.when((Object)appContext.getApplicationID()).thenReturn((Object)attemptid.getApplicationId());
        Mockito.when((Object)appContext.getApplicationAttemptId()).thenReturn((Object)attemptid);
        Mockito.when((Object)appContext.getEventHandler()).thenReturn((Object)dispatcher.getEventHandler());
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)clock);
        OutputCommitter committer = (OutputCommitter)Mockito.mock(OutputCommitter.class);
        TestingRMHeartbeatHandler rmhh = new TestingRMHeartbeatHandler();
        CommitterEventHandler ceh = new CommitterEventHandler(appContext, committer, (RMHeartbeatHandler)rmhh);
        ceh.init(conf);
        ceh.start();
        ceh.handle((CommitterEvent)new CommitterJobCommitEvent(null, null));
        for (timeToWaitMs = 5000L; rmhh.getNumCallbacks() != 1 && timeToWaitMs > 0L; timeToWaitMs -= 10L) {
            Thread.sleep(10L);
        }
        junit.framework.Assert.assertEquals((String)"committer did not register a heartbeat callback", (int)1, (int)rmhh.getNumCallbacks());
        ((OutputCommitter)Mockito.verify((Object)committer, (VerificationMode)Mockito.never())).commitJob((JobContext)Mockito.any(JobContext.class));
        junit.framework.Assert.assertEquals((String)"committer should not have committed", (int)0, (int)jeh.numCommitCompletedEvents);
        rmhh.setLastHeartbeatTime(clock.getTime());
        for (timeToWaitMs = 5000L; jeh.numCommitCompletedEvents != 1 && timeToWaitMs > 0L; timeToWaitMs -= 10L) {
            Thread.sleep(10L);
        }
        junit.framework.Assert.assertEquals((String)"committer did not complete commit after RM hearbeat", (int)1, (int)jeh.numCommitCompletedEvents);
        ((OutputCommitter)Mockito.verify((Object)committer, (VerificationMode)Mockito.times((int)1))).commitJob((JobContext)Mockito.any(JobContext.class));
        this.cleanup();
        ceh.handle((CommitterEvent)new CommitterJobCommitEvent(null, null));
        for (timeToWaitMs = 5000L; jeh.numCommitCompletedEvents != 2 && timeToWaitMs > 0L; timeToWaitMs -= 10L) {
            Thread.sleep(10L);
        }
        junit.framework.Assert.assertEquals((String)"committer did not commit", (int)2, (int)jeh.numCommitCompletedEvents);
        ((OutputCommitter)Mockito.verify((Object)committer, (VerificationMode)Mockito.times((int)2))).commitJob((JobContext)Mockito.any(JobContext.class));
        ceh.stop();
        dispatcher.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasic() throws Exception {
        AppContext mockContext = (AppContext)Mockito.mock(AppContext.class);
        OutputCommitter mockCommitter = (OutputCommitter)Mockito.mock(OutputCommitter.class);
        Clock mockClock = (Clock)Mockito.mock(Clock.class);
        CommitterEventHandler handler = new CommitterEventHandler(mockContext, mockCommitter, (RMHeartbeatHandler)new TestingRMHeartbeatHandler());
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        JobContext mockJobContext = (JobContext)Mockito.mock(JobContext.class);
        ApplicationAttemptId attemptid = ConverterUtils.toApplicationAttemptId((String)"appattempt_1234567890000_0001_0");
        JobId jobId = TypeConverter.toYarn((JobID)TypeConverter.fromYarn((ApplicationId)attemptid.getApplicationId()));
        WaitForItHandler waitForItHandler = new WaitForItHandler();
        Mockito.when((Object)mockContext.getApplicationID()).thenReturn((Object)attemptid.getApplicationId());
        Mockito.when((Object)mockContext.getApplicationAttemptId()).thenReturn((Object)attemptid);
        Mockito.when((Object)mockContext.getEventHandler()).thenReturn((Object)waitForItHandler);
        Mockito.when((Object)mockContext.getClock()).thenReturn((Object)mockClock);
        handler.init((Configuration)conf);
        handler.start();
        try {
            handler.handle((CommitterEvent)new CommitterJobCommitEvent(jobId, mockJobContext));
            String user = UserGroupInformation.getCurrentUser().getShortUserName();
            Path startCommitFile = MRApps.getStartJobCommitFile((Configuration)conf, (String)user, (JobId)jobId);
            Path endCommitSuccessFile = MRApps.getEndJobCommitSuccessFile((Configuration)conf, (String)user, (JobId)jobId);
            Path endCommitFailureFile = MRApps.getEndJobCommitFailureFile((Configuration)conf, (String)user, (JobId)jobId);
            Event e = waitForItHandler.getAndClearEvent();
            Assert.assertNotNull((Object)e);
            Assert.assertTrue((boolean)(e instanceof JobCommitCompletedEvent));
            FileSystem fs = FileSystem.get((Configuration)conf);
            Assert.assertTrue((String)startCommitFile.toString(), (boolean)fs.exists(startCommitFile));
            Assert.assertTrue((String)endCommitSuccessFile.toString(), (boolean)fs.exists(endCommitSuccessFile));
            Assert.assertFalse((String)endCommitFailureFile.toString(), (boolean)fs.exists(endCommitFailureFile));
            ((OutputCommitter)Mockito.verify((Object)mockCommitter)).commitJob((JobContext)Mockito.any(JobContext.class));
        }
        finally {
            handler.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailure() throws Exception {
        AppContext mockContext = (AppContext)Mockito.mock(AppContext.class);
        OutputCommitter mockCommitter = (OutputCommitter)Mockito.mock(OutputCommitter.class);
        Clock mockClock = (Clock)Mockito.mock(Clock.class);
        CommitterEventHandler handler = new CommitterEventHandler(mockContext, mockCommitter, (RMHeartbeatHandler)new TestingRMHeartbeatHandler());
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        JobContext mockJobContext = (JobContext)Mockito.mock(JobContext.class);
        ApplicationAttemptId attemptid = ConverterUtils.toApplicationAttemptId((String)"appattempt_1234567890000_0001_0");
        JobId jobId = TypeConverter.toYarn((JobID)TypeConverter.fromYarn((ApplicationId)attemptid.getApplicationId()));
        WaitForItHandler waitForItHandler = new WaitForItHandler();
        Mockito.when((Object)mockContext.getApplicationID()).thenReturn((Object)attemptid.getApplicationId());
        Mockito.when((Object)mockContext.getApplicationAttemptId()).thenReturn((Object)attemptid);
        Mockito.when((Object)mockContext.getEventHandler()).thenReturn((Object)waitForItHandler);
        Mockito.when((Object)mockContext.getClock()).thenReturn((Object)mockClock);
        ((OutputCommitter)Mockito.doThrow((Throwable)new YarnRuntimeException("Intentional Failure")).when((Object)mockCommitter)).commitJob((JobContext)Mockito.any(JobContext.class));
        handler.init((Configuration)conf);
        handler.start();
        try {
            handler.handle((CommitterEvent)new CommitterJobCommitEvent(jobId, mockJobContext));
            String user = UserGroupInformation.getCurrentUser().getShortUserName();
            Path startCommitFile = MRApps.getStartJobCommitFile((Configuration)conf, (String)user, (JobId)jobId);
            Path endCommitSuccessFile = MRApps.getEndJobCommitSuccessFile((Configuration)conf, (String)user, (JobId)jobId);
            Path endCommitFailureFile = MRApps.getEndJobCommitFailureFile((Configuration)conf, (String)user, (JobId)jobId);
            Event e = waitForItHandler.getAndClearEvent();
            Assert.assertNotNull((Object)e);
            Assert.assertTrue((boolean)(e instanceof JobCommitFailedEvent));
            FileSystem fs = FileSystem.get((Configuration)conf);
            Assert.assertTrue((boolean)fs.exists(startCommitFile));
            Assert.assertFalse((boolean)fs.exists(endCommitSuccessFile));
            Assert.assertTrue((boolean)fs.exists(endCommitFailureFile));
            ((OutputCommitter)Mockito.verify((Object)mockCommitter)).commitJob((JobContext)Mockito.any(JobContext.class));
        }
        finally {
            handler.stop();
        }
    }

    private static class TestingJobEventHandler
    implements EventHandler<JobEvent> {
        int numCommitCompletedEvents = 0;

        private TestingJobEventHandler() {
        }

        public void handle(JobEvent event) {
            if (event.getType() == JobEventType.JOB_COMMIT_COMPLETED) {
                ++this.numCommitCompletedEvents;
            }
        }
    }

    private static class TestingRMHeartbeatHandler
    implements RMHeartbeatHandler {
        private long lastHeartbeatTime = 0L;
        private ConcurrentLinkedQueue<Runnable> callbacks = new ConcurrentLinkedQueue();

        private TestingRMHeartbeatHandler() {
        }

        public long getLastHeartbeatTime() {
            return this.lastHeartbeatTime;
        }

        public void runOnNextHeartbeat(Runnable callback) {
            this.callbacks.add(callback);
        }

        public void setLastHeartbeatTime(long timestamp) {
            this.lastHeartbeatTime = timestamp;
            Runnable callback = null;
            while ((callback = this.callbacks.poll()) != null) {
                callback.run();
            }
        }

        public int getNumCallbacks() {
            return this.callbacks.size();
        }
    }

    public static class WaitForItHandler
    implements EventHandler {
        private Event event = null;

        public synchronized void handle(Event event) {
            this.event = event;
            this.notifyAll();
        }

        public synchronized Event getAndClearEvent() throws InterruptedException {
            if (this.event == null) {
                this.wait(100L);
            }
            Event e = this.event;
            this.event = null;
            return e;
        }
    }
}

