/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherEvent;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerRemoteLaunchEvent;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.junit.Test;

public class TestMapReduceChildJVM {
    private static final Log LOG = LogFactory.getLog(TestMapReduceChildJVM.class);

    @Test(timeout=30000L)
    public void testCommandLine() throws Exception {
        MyMRApp app = new MyMRApp(1, 0, true, this.getClass().getName(), true);
        Job job = app.submit(new Configuration());
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        Assert.assertEquals((String)("[" + TestMapReduceChildJVM.envVar("JAVA_HOME") + "/bin/java" + " -Djava.net.preferIPv4Stack=true" + " -Dhadoop.metrics.log.level=WARN" + "  -Xmx200m -Djava.io.tmpdir=" + TestMapReduceChildJVM.envVar("PWD") + "/tmp" + " -Dlog4j.configuration=container-log4j.properties" + " -Dyarn.app.container.log.dir=<LOG_DIR>" + " -Dyarn.app.container.log.filesize=0" + " -Dhadoop.root.logger=INFO,CLA" + " org.apache.hadoop.mapred.YarnChild 127.0.0.1" + " 54321" + " attempt_0_0000_m_000000_0" + " 0" + " 1><LOG_DIR>/stdout" + " 2><LOG_DIR>/stderr ]"), (String)app.myCommandLine);
    }

    private static String envVar(String name) {
        return Shell.WINDOWS ? '%' + name + '%' : '$' + name;
    }

    private static final class MyMRApp
    extends MRApp {
        private String myCommandLine;

        public MyMRApp(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart) {
            super(maps, reduces, autoComplete, testName, cleanOnStart);
        }

        @Override
        protected ContainerLauncher createContainerLauncher(AppContext context) {
            return new MRApp.MockContainerLauncher(){

                @Override
                public void handle(ContainerLauncherEvent event) {
                    if (event.getType() == ContainerLauncher.EventType.CONTAINER_REMOTE_LAUNCH) {
                        ContainerRemoteLaunchEvent launchEvent = (ContainerRemoteLaunchEvent)event;
                        ContainerLaunchContext launchContext = launchEvent.getContainerLaunchContext();
                        String cmdString = launchContext.getCommands().toString();
                        LOG.info((Object)("launchContext " + cmdString));
                        MyMRApp.this.myCommandLine = cmdString;
                    }
                    super.handle(event);
                }
            };
        }
    }
}

