import os, sys, json, subprocess, socket, time, argparse, random
from sys import stdout

from twisted.internet import reactor
from twisted.internet.protocol import Protocol, Factory, ClientFactory

timeflt = lambda: time.time()
try:
    sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
except:
    pass

verbose = False

def setupArgParse():
    p = argparse.ArgumentParser(description='Perform tests by connecting to the YARN/HADOOP Client')
    p.add_argument('-host', help='Host name', type=str, default='localhost')
    p.add_argument('-p', help='Port', type=int, default=12345)
    p.add_argument('-q', help='Query', type=str, default="")
    return p

class SenderProtocol(Protocol):
    """
        This class is in charge of keeping the routers up to date with config data.
    """
    def __init__(self, addr, f):
        self.addr = addr
        self.factory = f
    
    def connectionMade(self):
        print('=============== Starting testing ================')
        # Get the first data and send it
        req = self.factory.getQuery()
        try:
            sock.sendto("PERF_BEFORE_QUERY %f" % time.time(), ("128.105.22.232", 6666))
        except:
            pass
        
        self.transport.write(req + "\n")

    def dataReceived(self, data):
        if(self.factory.doingQuery()):
            try:
                sock.sendto("PERF_AFTER_QUERY %f" % time.time(), ("128.105.22.232", 6666))
            except:
                pass
            self.factory.doneQuery()
            self.transport.write("!exit\n")
            return

    def connectionLost(self, reason):
        print('Connection lost')
        reactor.stop()

class SenderFactory(Factory):
    def __init__(self, host, port, query):
        self.host = host
        self.port = port
        self.query = query
        self.queryStart = 0.0
        self.qFlag = False
    
    def buildProtocol(self, addr):
        return SenderProtocol(addr, self)

    def getQuery(self):
        self.qFlag = True
        self.queryStart = time.time()
        return self.query

    def doingQuery(self):
        return self.qFlag

    def doneQuery(self):
        print("Query took: %f" % (time.time() - self.queryStart))
    
    def startedConnecting(self, connector):
        pass

    def clientConnectionLost(self, connector, reason):
        pass

    def clientConnectionFailed(self, connector, reason):
        print('Cannot connect')


###############################################################################
# Main
p = setupArgParse()
args = p.parse_args()

host = args.host
port = args.p
query = args.q


f = SenderFactory(host, port, query)
reactor.connectTCP(host, port, f)
reactor.run()
