#!/bin/bash

function killme {
    echo "Caught exit"
    exit 0
}
function funcGetPartArg {
    echo `python getpartitionarg.py $1 $2 $3`
}

trap killme SIGINT

NUMBER_NODES="1 2 4"
TABLE_SIZE="10 50 100 250"
PARTITION_TYPE="random roundrobin hash range"

if [ "$1" = "-?" ]; then
    echo "Usage: $0 [NODENUM TBLSIZE PARTTYPE]"
    echo "restart testing from the defined values order is PARTTYPE then TBLSIZE then NODENUM"
    echo "Valid data:"
    echo "PART TYPE:  $PARTITION_TYPE"
    echo "TABLE SIZE: $TABLE_SIZE"
    echo "NUM NODES:  $NUMBER_NODES"
    exit 0
fi

# check if we should start from a specific point
if [ $# -eq 3 ]; then
    N_WORKED_ON="$1"
    TS_WORKED_ON="$2"
    PT_WORKED_ON="$3"
    WORKING=0
else
    WORKING=1
fi


for N in $NUMBER_NODES; do
    for TS in $TABLE_SIZE; do
        for PT in $PARTITION_TYPE; do
            # See if we got to our "working" point
            if [ $WORKING -eq 0 ]; then
                #Check for a match
                if [ "$N_WORKED_ON" = "$N" ] && [ "$TS_WORKED_ON" = "$TS" ] && [ "$PT_WORKED_ON" = "$PT" ]; then
                    echo "============================================================================="
                    echo "Found working match, restarting from here"
                    echo "============================================================================="
                    WORKING=1
                else
                    # Didn't get to our working point yet, keep searching
                    continue
                fi
            fi
            echo "============================================================================="
            echo "============================================================================="
            echo "<<<<<<<<<<<<<<<<<<<<<<<< $PT $TS $N >>>>>>>>>>>>>>>>>>>>>>>>>>>"
            echo "============================================================================="
            echo "============================================================================="
            echo "yarn jar distributedDB.jar distributeddb.Client -db quickstep &"
            eval "yarn jar distributedDB.jar distributeddb.Client -db quickstep &"
            echo "============================================================================="
            echo "===== Sleeping for 20 seconds so yarn can start"
            echo "============================================================================="
            sleep 20
            PA=`funcGetPartArg $N $TS $PT`
            echo "python perf_test.py -host wah -p 12345 -t $PT -a '$PA' -s $TS -num $N 2>>result_$PT.txt"
            eval "python perf_test.py -host wah -p 12345 -t $PT -a '$PA' -s $TS -num $N 2>>result_$PT.txt"
            if [ $? -ne 0 ]; then
                echo "Non zero return exit"
                exit 1
            fi

            # Make sure yarn isn't running
            YARNON=`yarn application -list | tail -n 1 | grep "DistributedDB" | wc -l`
            if [ $YARNON -ne 0 ]; then
                echo "============================================================================="
                echo "===== YARN APPLICATION STILL RUNNING"
                echo "============================================================================="
                exit 0
            fi
            
            echo "============================================================================="
            echo "===== Clearing all data"
            echo "============================================================================="
            echo "./clear_all.sh"
            eval "./clear_all.sh"
        done
    done
done
